/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.util.monitor;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import net.e6tech.elements.common.util.monitor.AllocationListener;

public class AllocationMonitor {
    private ReferenceQueue<Object> phantoms = new ReferenceQueue();
    private Thread gcThread = new Thread();
    Set<AllocationReference> allocated = Collections.synchronizedSet(new LinkedHashSet());
    private long checkInterval = 60000L;
    private long expired = 60000L;
    private boolean disabled = false;

    public void monitor(long timeout, Object obj, AllocationListener listener) {
        if (this.disabled) {
            return;
        }
        if (timeout <= 0L) {
            timeout = this.expired;
        }
        this.allocated.add(new AllocationReference(timeout, obj, this.phantoms, listener));
        this.checkGCThread();
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(long checkInterval) {
        this.checkInterval = checkInterval;
    }

    public long getExpired() {
        return this.expired;
    }

    public void setExpired(long expired) {
        this.expired = expired;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    protected synchronized void checkGCThread() {
        if (this.gcThread.isAlive()) {
            return;
        }
        this.gcThread = new Thread(() -> {
            try {
                Thread.sleep(this.checkInterval);
                System.gc();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            try {
                while (true) {
                    Reference<Object> ref = this.phantoms.poll();
                    while (ref != null) {
                        ref = this.phantoms.remove();
                        this.allocated.remove(ref);
                        ref = this.phantoms.poll();
                    }
                    Set<AllocationReference> set = this.allocated;
                    synchronized (set) {
                        Iterator<AllocationReference> iterator = this.allocated.iterator();
                        while (iterator.hasNext()) {
                            AllocationReference alloc = iterator.next();
                            if (System.currentTimeMillis() <= alloc.expiredTime) continue;
                            alloc.getListener().onPotentialLeak();
                            iterator.remove();
                        }
                    }
                    Thread.sleep(this.checkInterval);
                }
            }
            catch (InterruptedException e) {
                return;
            }
        });
        this.gcThread.setDaemon(true);
        this.gcThread.start();
    }

    static class AllocationReference
    extends PhantomReference {
        AllocationListener listener;
        long startTime;
        long expiredTime;

        public AllocationReference(long timeout, Object referent, ReferenceQueue q, AllocationListener listener) {
            super(referent, q);
            this.expiredTime = System.currentTimeMillis() + timeout;
            this.listener = listener;
        }

        public AllocationListener getListener() {
            return this.listener;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public boolean equals(Object object) {
            if (!(object instanceof AllocationReference)) {
                return false;
            }
            return System.identityHashCode(this) == System.identityHashCode(object);
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }
    }
}

