/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.interceptor;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Ownership;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.SuperMethodCall;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.This;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.e6tech.elements.common.interceptor.CallFrame;
import net.e6tech.elements.common.interceptor.InterceptorHandler;
import net.e6tech.elements.common.interceptor.InterceptorListener;
import net.e6tech.elements.common.interceptor.JoinClassLoader;
import net.e6tech.elements.common.reflection.Primitives;
import net.e6tech.elements.common.reflection.Reflection;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.util.SystemException;

public class Interceptor {
    private static final String HANDLER_FIELD = "handler";
    private static Interceptor instance = new Interceptor();
    private static ThreadLocal<Object> anonymousThreadLocal = new ThreadLocal();
    private int initialCapacity = 100;
    private int maximumSize = 1000;
    private long expiration = 3600000L;
    private Cache<Class, Class> proxyClasses;
    private Cache<Class, Class> singletonClasses;
    private Cache<Class, AnonymousDescriptor> anonymousClasses;

    public static Interceptor getInstance() {
        return instance;
    }

    public Interceptor() {
        this.initialize();
    }

    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    public void setInitialCapacity(int initialCapacity) {
        this.initialCapacity = initialCapacity;
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(int maximumSize) {
        this.maximumSize = maximumSize;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    private <T> Cache<Class, T> createCache() {
        return CacheBuilder.newBuilder().initialCapacity(this.initialCapacity).maximumSize((long)this.maximumSize).expireAfterWrite(this.expiration, TimeUnit.MILLISECONDS).concurrencyLevel(Provision.cacheBuilderConcurrencyLevel.intValue()).build();
    }

    public void initialize() {
        this.proxyClasses = this.createCache();
        this.singletonClasses = this.createCache();
        this.anonymousClasses = this.createCache();
    }

    private <T> Class<? extends T> loadClass(DynamicType.Unloaded<T> unloaded, Class<T> cls, ClassLoader classLoader) {
        DynamicType.Loaded loaded;
        try {
            loaded = classLoader != null ? unloaded.load(classLoader) : (cls.getClassLoader() == null ? unloaded.load(this.getClass().getClassLoader()) : unloaded.load(cls.getClassLoader()));
        }
        catch (NoClassDefFoundError ex) {
            ClassLoader delegateLoader = cls.getClassLoader();
            if (delegateLoader == null) {
                delegateLoader = ClassLoader.getSystemClassLoader();
            }
            loaded = unloaded.load((ClassLoader)new JoinClassLoader(this.getClass().getClassLoader(), delegateLoader));
        }
        return loaded.getLoaded();
    }

    public <T> Class<T> newPrototypeClass(Class<T> cls, T prototype) {
        return this.newPrototypeClass(cls, prototype, null);
    }

    public <T> Class<T> newPrototypeClass(Class<T> cls, T prototype, ClassLoader classLoader) {
        DynamicType.Unloaded unloaded = new ByteBuddy().subclass(cls).constructor((ElementMatcher)ElementMatchers.any()).intercept((Implementation)SuperMethodCall.INSTANCE.andThen((Implementation.Composable)MethodDelegation.to(new PrototypeConstructor<T>(prototype)))).make();
        return this.loadClass(unloaded, cls, classLoader);
    }

    public <T> Class<T> newSingletonClass(Class<T> cls, T singleton) {
        return this.newSingletonClass(cls, singleton, null, null);
    }

    public <T> Class<T> newSingletonClass(Class<T> cls, T singleton, InterceptorListener listener, ClassLoader classLoader) {
        if (singleton == null) {
            throw new IllegalArgumentException("target cannot be null");
        }
        try {
            Class proxyClass = (Class)this.singletonClasses.get(cls, () -> this.loadClass(this.newSingletonBuilder(cls).make(), cls, classLoader));
            Field field = proxyClass.getDeclaredField(HANDLER_FIELD);
            field.setAccessible(true);
            InterceptorHandlerWrapper wrapper = new InterceptorHandlerWrapper(this, proxyClass, singleton, ctx -> ctx.invoke(singleton), listener);
            field.set(null, wrapper);
            return proxyClass;
        }
        catch (ExecutionException e) {
            throw new SystemException(e.getCause());
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    private <T> DynamicType.Builder<T> newSingletonBuilder(Class<T> cls) {
        return new ByteBuddy().subclass(cls).method((ElementMatcher)ElementMatchers.any().and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.named((String)"finalize").and((ElementMatcher)ElementMatchers.hasParameters((ElementMatcher)ElementMatchers.none()))))).intercept((Implementation)MethodDelegation.toField((String)HANDLER_FIELD)).defineField(HANDLER_FIELD, Handler.class, new ModifierContributor.ForField[]{Visibility.PRIVATE, Ownership.STATIC});
    }

    private ClassLoadingStrategy getClassLoadingStrategy(MethodHandles.Lookup lookup, Class targetClass) {
        ClassLoadingStrategy.Default strategy;
        block5: {
            try {
                if (ClassInjector.UsingLookup.isAvailable()) {
                    Class<?> methodHandles = Class.forName("java.lang.invoke.MethodHandles");
                    Method lookupMethod = methodHandles.getMethod("lookup", new Class[0]);
                    if (lookup == null) {
                        lookup = (MethodHandles.Lookup)lookupMethod.invoke(null, new Object[0]);
                    }
                    Method privateLookupIn = methodHandles.getMethod("privateLookupIn", Class.class, Class.forName("java.lang.invoke.MethodHandles$Lookup"));
                    Object privateLookup = privateLookupIn.invoke(null, targetClass, lookup);
                    strategy = ClassLoadingStrategy.UsingLookup.of((Object)privateLookup);
                    break block5;
                }
                if (ClassInjector.UsingReflection.isAvailable()) {
                    strategy = ClassLoadingStrategy.Default.INJECTION;
                    break block5;
                }
                throw new IllegalStateException("No code loading strategy available");
            }
            catch (Exception ex) {
                throw new SystemException(ex);
            }
        }
        return strategy;
    }

    public <T> void runAnonymous(T target, T anonymous) {
        this.runAnonymous(null, target, anonymous);
    }

    public <T> void runAnonymous(MethodHandles.Lookup lookup, T target, T anonymous) {
        Class<?> anonymousClass = anonymous.getClass();
        try {
            AnonymousDescriptor descriptor = (AnonymousDescriptor)this.anonymousClasses.get(anonymousClass, () -> {
                ClassLoadingStrategy strategy;
                Class<?> enclosingClass = anonymousClass.getEnclosingClass();
                if (lookup == null && enclosingClass != null && ClassInjector.UsingLookup.isAvailable() && Modifier.isPublic(enclosingClass.getModifiers())) {
                    Class<?> methodHandles = Class.forName("java.lang.invoke.MethodHandles");
                    Method lookupMethod = methodHandles.getMethod("lookup", new Class[0]);
                    DynamicType.Unloaded unloaded = new ByteBuddy().subclass(enclosingClass).defineMethod("_methodHandlesLookup", MethodHandles.Lookup.class, 9).intercept((Implementation)MethodCall.invoke((Method)lookupMethod)).make();
                    Class<?> enclosingClass2 = this.loadClass(unloaded, enclosingClass, null);
                    Method enclosingLookup = enclosingClass2.getMethod("_methodHandlesLookup", new Class[0]);
                    MethodHandles.Lookup lookup2 = (MethodHandles.Lookup)enclosingLookup.invoke(null, new Object[0]);
                    strategy = this.getClassLoadingStrategy(lookup2, anonymousClass);
                } else {
                    strategy = this.getClassLoadingStrategy(lookup, anonymousClass);
                }
                DynamicType.Builder builder = this.newSingletonBuilder(anonymousClass);
                Class p = builder.make().load(anonymousClass.getClassLoader(), strategy).getLoaded();
                Field field = p.getDeclaredField(HANDLER_FIELD);
                field.setAccessible(true);
                InterceptorHandlerWrapper wrapper = new InterceptorHandlerWrapper(this, p, null, ctx -> {
                    Throwable th = new Throwable();
                    StackTraceElement[] elements = th.getStackTrace();
                    if (elements[3].getClassName().equals(anonymousClass.getName())) {
                        Object t = anonymousThreadLocal.get();
                        return ctx.invoke(t);
                    }
                    return Primitives.defaultValue(ctx.getMethod().getReturnType());
                }, null);
                field.set(null, wrapper);
                Field[] fields = anonymousClass.getDeclaredFields();
                AnonymousDescriptor desc = new AnonymousDescriptor();
                Field[] copy = new Field[fields.length];
                copy[0] = fields[fields.length - 1];
                System.arraycopy(fields, 0, copy, 1, fields.length - 1);
                for (Field f : desc.fields = copy) {
                    f.setAccessible(true);
                }
                desc.classes = new Class[copy.length];
                for (int i = 0; i < copy.length; ++i) {
                    desc.classes[i] = copy[i].getType();
                }
                desc.constructor = p.getDeclaredConstructor(desc.classes);
                return desc;
            });
            anonymousThreadLocal.set(target);
            descriptor.construct(anonymous);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        finally {
            anonymousThreadLocal.remove();
        }
    }

    public <T> T newInterceptor(T instance, InterceptorHandler handler) {
        return this.newInterceptor(instance, handler, null, null);
    }

    public <T> T newInterceptor(T instance, InterceptorHandler handler, ClassLoader classLoader) {
        return this.newInterceptor(instance, handler, null, classLoader);
    }

    public <T> T newInterceptor(T instance, InterceptorHandler handler, InterceptorListener listener, ClassLoader classLoader) {
        Class proxyClass = this.createInstanceClass(instance.getClass(), classLoader);
        T proxyObject = this.newObject(proxyClass);
        InterceptorHandlerWrapper wrapper = new InterceptorHandlerWrapper(this, proxyClass, instance, handler, listener);
        ((HandlerAccessor)proxyObject).setHandler(wrapper);
        return proxyObject;
    }

    public <T> T newInstance(Class cls, InterceptorHandler handler) {
        return this.newInstance(cls, handler, null, null);
    }

    public <T> T newInstance(Class cls, InterceptorHandler handler, InterceptorListener listener) {
        return this.newInstance(cls, handler, listener, null);
    }

    public <T> T newInstance(Class cls, InterceptorHandler handler, InterceptorListener listener, ClassLoader classLoader) {
        Class proxyClass = this.createInstanceClass(cls, classLoader);
        T proxyObject = this.newObject(proxyClass);
        InterceptorHandlerWrapper wrapper = null;
        try {
            Object target = null;
            if (!cls.isInterface()) {
                target = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            wrapper = new InterceptorHandlerWrapper(this, proxyClass, target, handler, listener);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        wrapper.targetClass = cls;
        ((HandlerAccessor)proxyObject).setHandler(wrapper);
        return proxyObject;
    }

    private Class createInstanceClass(Class cls, ClassLoader classLoader) {
        try {
            return (Class)this.proxyClasses.get((Object)cls, () -> {
                DynamicType.Unloaded unloaded = new ByteBuddy().subclass(cls).method((ElementMatcher)ElementMatchers.any().and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isDeclaredBy(Object.class)))).intercept((Implementation)MethodDelegation.toField((String)HANDLER_FIELD)).defineField(HANDLER_FIELD, Handler.class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).implement(new Type[]{HandlerAccessor.class}).intercept((Implementation)FieldAccessor.ofBeanProperty()).make();
                return this.loadClass(unloaded, cls, classLoader);
            });
        }
        catch (ExecutionException e) {
            throw new SystemException(e.getCause());
        }
    }

    private <T> T newObject(Class proxyClass) {
        Object proxyObject;
        try {
            proxyObject = proxyClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        return proxyObject;
    }

    public static boolean isProxyObject(Object proxyObject) {
        return proxyObject instanceof HandlerAccessor;
    }

    public static <T> T cloneProxyObject(T proxyObject) {
        if (!(proxyObject instanceof HandlerAccessor)) {
            throw new IllegalArgumentException("argument is not a proxy object");
        }
        InterceptorHandlerWrapper wrapper = (InterceptorHandlerWrapper)((HandlerAccessor)proxyObject).getHandler();
        wrapper = new InterceptorHandlerWrapper(wrapper);
        Interceptor interceptor = wrapper.interceptor;
        T cloneProxy = interceptor.newObject(wrapper.proxyClass);
        ((HandlerAccessor)cloneProxy).setHandler(wrapper);
        return cloneProxy;
    }

    public static <T> T getTarget(T proxyObject) {
        InterceptorHandlerWrapper wrapper = (InterceptorHandlerWrapper)((HandlerAccessor)proxyObject).getHandler();
        return (T)wrapper.target;
    }

    public static <T> void setTarget(T proxyObject, T target) {
        InterceptorHandlerWrapper wrapper = (InterceptorHandlerWrapper)((HandlerAccessor)proxyObject).getHandler();
        if (target != null && !target.getClass().isAssignableFrom(wrapper.targetClass)) {
            throw new IllegalArgumentException("Target class " + target.getClass() + " is not assignable from " + wrapper.targetClass);
        }
        wrapper.target = target;
    }

    public static Class getTargetClass(Object proxyObject) {
        InterceptorHandlerWrapper wrapper = (InterceptorHandlerWrapper)((HandlerAccessor)proxyObject).getHandler();
        return wrapper.targetClass;
    }

    public static <T extends InterceptorHandler> T getInterceptorHandler(Object proxyObject) {
        InterceptorHandlerWrapper wrapper = (InterceptorHandlerWrapper)((HandlerAccessor)proxyObject).getHandler();
        return (T)wrapper.handler;
    }

    public static <T extends InterceptorHandler> void setInterceptorHandler(Object proxyObject, T handler) {
        InterceptorHandlerWrapper wrapper = (InterceptorHandlerWrapper)((HandlerAccessor)proxyObject).getHandler();
        wrapper.handler = handler;
    }

    public static <T extends InterceptorListener> T getInterceptorListener(Object proxyObject) {
        InterceptorHandlerWrapper wrapper = (InterceptorHandlerWrapper)((HandlerAccessor)proxyObject).getHandler();
        return (T)wrapper.listener;
    }

    public static <T extends InterceptorListener> void setInterceptorListener(Object proxyObject, T handler) {
        InterceptorHandlerWrapper wrapper = (InterceptorHandlerWrapper)((HandlerAccessor)proxyObject).getHandler();
        wrapper.listener = handler;
    }

    private static class InterceptorHandlerWrapper
    implements Handler {
        InterceptorHandler handler;
        InterceptorListener listener;
        Object target;
        Class targetClass;
        Class proxyClass;
        Interceptor interceptor;

        InterceptorHandlerWrapper(Interceptor interceptor, Class proxyClass, Object target, InterceptorHandler handler, InterceptorListener listener) {
            this.interceptor = interceptor;
            this.proxyClass = proxyClass;
            this.handler = handler;
            this.listener = listener;
            this.target = target;
            if (target != null) {
                this.targetClass = target.getClass();
            }
        }

        InterceptorHandlerWrapper(InterceptorHandlerWrapper copy) {
            this.interceptor = copy.interceptor;
            this.proxyClass = copy.proxyClass;
            this.handler = copy.handler;
            this.listener = copy.listener;
            this.target = copy.target;
            this.targetClass = copy.targetClass;
        }

        @Override
        public Object handle(MethodHandle methodHandle, Method method, @RuntimeType Object[] arguments) throws Throwable {
            CallFrame frame = new CallFrame(this.target, methodHandle, method, arguments);
            if (this.listener != null) {
                this.listener.preInvocation(frame);
            }
            Object ret = null;
            try {
                ret = this.handler.invoke(frame);
            }
            catch (Throwable throwable) {
                if (this.listener != null) {
                    return this.listener.onException(frame, throwable);
                }
                throw throwable;
            }
            if (this.listener != null) {
                ret = this.listener.postInvocation(frame, ret);
            }
            return ret;
        }
    }

    public static interface HandlerAccessor {
        public Handler getHandler();

        public void setHandler(Handler var1);
    }

    @FunctionalInterface
    public static interface Handler {
        @RuntimeType
        public Object handle(@Origin MethodHandle var1, @Origin Method var2, @AllArguments Object[] var3) throws Throwable;
    }

    private static final class AnonymousDescriptor {
        Field[] fields;
        Class[] classes;
        Constructor constructor;

        private AnonymousDescriptor() {
        }

        final void construct(Object anonymous) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            Object[] values = new Object[this.fields.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.fields[i].get(anonymous);
            }
            this.constructor.newInstance(values);
        }
    }

    public static class PrototypeConstructor<T> {
        T prototype;

        public PrototypeConstructor(T prototype) {
            this.prototype = prototype;
        }

        public void construct(@This Object instance) {
            if (this.prototype != null) {
                Reflection.copyInstance(instance, this.prototype);
            }
        }
    }
}

