/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.reflection;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.reflection.CopyListener;
import net.e6tech.elements.common.reflection.DoNotAccept;
import net.e6tech.elements.common.reflection.DoNotCopy;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.common.util.TextSubstitution;
import net.e6tech.elements.common.util.datastructure.Pair;
import net.e6tech.elements.common.util.lambda.Each;

public class Reflection {
    private static Set<Class> convertibleTypes = new HashSet<Class>();
    private static final PrivateSecurityManager securityManager;
    private static LoadingCache<Method, PropertyDescriptor> methodPropertyDescriptors;
    private static LoadingCache<Pair<Class, String>, PropertyDescriptor> propertyDescriptors;
    private static LoadingCache<Class, Type[]> parametrizedTypes;
    static Logger logger;

    private Reflection() {
    }

    public static PropertyDescriptor propertyDescriptor(Method method) {
        try {
            return (PropertyDescriptor)methodPropertyDescriptors.get((Object)method);
        }
        catch (ExecutionException e) {
            throw new SystemException(e.getCause());
        }
    }

    public static Class getCallingClass() {
        int i;
        Class<?>[] trace = securityManager.getClassContext();
        String thisClassName = Reflection.class.getName();
        for (i = 0; i < trace.length && !thisClassName.equals(trace[i].getName()); ++i) {
        }
        if (i >= trace.length || i + 2 >= trace.length) {
            throw new IllegalStateException("Failed to find caller in the stack");
        }
        return trace[i + 2];
    }

    public static <V, C> Optional<V> mapCallingStackTrace(Function<Each<StackTraceElement, C>, ? extends V> mapper) {
        Throwable th = new Throwable();
        StackTraceElement[] trace = th.getStackTrace();
        String thisClassName = Reflection.class.getName();
        for (int i = 0; i < trace.length && !thisClassName.equals(trace[i].getClassName()); ++i) {
        }
        Each.Mutator mutator = Each.create();
        for (int j = i + 2; j < trace.length; ++j) {
            mutator.setValue(trace[j]);
            V v = mapper.apply(mutator.each());
            if (v == null) continue;
            return Optional.of(v);
        }
        return Optional.empty();
    }

    public static void printStackTrace(StringBuilder builder, String indent, int start, int end) {
        StackTraceElement[] elements = new Throwable().getStackTrace();
        for (int i = start + 1; i < end && i < elements.length; ++i) {
            builder.append("\n");
            if (indent != null) {
                builder.append(indent);
            }
            builder.append(elements[i].getClassName());
            builder.append(".");
            builder.append(elements[i].getMethodName());
            builder.append("(");
            builder.append(elements[i].getFileName());
            builder.append(":");
            builder.append(elements[i].getLineNumber());
            builder.append(")");
        }
    }

    public static <T> T newInstance(String className, ClassLoader loader) {
        try {
            return Reflection.loadClass(className, loader).newInstance();
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    public static Class loadClass(String className, ClassLoader classLoader) {
        ClassLoader loader = classLoader;
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if (loader == null) {
            loader = Reflection.getCallingClass().getClassLoader();
        }
        try {
            return loader.loadClass(className);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    public static BeanInfo getBeanInfo(Class cls) {
        try {
            return Introspector.getBeanInfo(cls);
        }
        catch (IntrospectionException e) {
            throw new SystemException(e);
        }
    }

    public static void forEachAnnotatedAccessor(Class objectClass, Class<? extends Annotation> annotationClass, Consumer<AccessibleObject> consumer) {
        PropertyDescriptor[] props;
        Class cls = objectClass;
        BeanInfo beanInfo = Reflection.getBeanInfo(cls);
        for (PropertyDescriptor prop : props = beanInfo.getPropertyDescriptors()) {
            if (prop.getReadMethod() == null || prop.getReadMethod().getAnnotation(annotationClass) == null) continue;
            consumer.accept(prop.getReadMethod());
        }
        while (!cls.equals(Object.class)) {
            Field[] fields;
            for (Field field : fields = cls.getDeclaredFields()) {
                if (field.getAnnotation(annotationClass) == null) continue;
                consumer.accept(field);
            }
            cls = cls.getSuperclass();
        }
    }

    public static <V> V getProperty(Object object, String property) {
        try {
            Class<?> cls = null;
            cls = object instanceof Class ? (Class<?>)object : object.getClass();
            PropertyDescriptor descriptor = Reflection.getPropertyDescriptor(cls, property);
            if (descriptor == null || descriptor.getReadMethod() == null) {
                return null;
            }
            return (V)descriptor.getReadMethod().invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new SystemException(object.getClass().getName() + "." + property, e);
        }
    }

    public static PropertyDescriptor getPropertyDescriptor(Class cls, String property) {
        try {
            return (PropertyDescriptor)propertyDescriptors.get(new Pair<Class, String>(cls, property));
        }
        catch (ExecutionException e) {
            throw new SystemException(e.getCause());
        }
    }

    public static <V> V getField(Object object, String fieldName) {
        Field field = Reflection.getField(object.getClass(), fieldName);
        try {
            return (V)field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void setField(Object object, String fieldName, Object value) {
        Field field = Reflection.getField(object.getClass(), fieldName);
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Field getField(Class clazz, String fieldName) {
        for (Class cls = clazz; cls != null && !cls.equals(Object.class); cls = cls.getSuperclass()) {
            try {
                Field field = cls.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            }
            catch (Exception e) {
                Logger.suppress(e);
                try {
                    continue;
                }
                catch (Exception e2) {
                    throw new IllegalStateException(e2);
                }
            }
        }
        throw new IllegalStateException("No bankId defined");
    }

    public static Class getParametrizedType(Class clazz, int index) {
        Type[] types;
        try {
            types = (Type[])parametrizedTypes.get((Object)clazz);
        }
        catch (ExecutionException e) {
            throw new SystemException(e.getCause());
        }
        if (types.length <= index) {
            throw new IllegalArgumentException("No parametrized type at index=" + index);
        }
        if (types[index] instanceof Class) {
            return (Class)types[index];
        }
        if (types[index] instanceof ParameterizedType && ((ParameterizedType)types[index]).getRawType() instanceof Class) {
            return (Class)((ParameterizedType)types[index]).getRawType();
        }
        return null;
    }

    public static <T> List<T> newInstance(Class<T> cls, List objectList) {
        return Reflection.newInstance(cls, objectList, null);
    }

    public static <T> List<T> newInstance(Class<T> cls, List objectList, CopyListener listener) {
        if (objectList == null) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (Object o : objectList) {
            T target = new Replicator().newInstance(cls, o, listener);
            list.add(target);
        }
        return list;
    }

    public static <T> T newInstance(Class<T> cls, Object object) {
        return (T)new Replicator().newInstance(cls, object, new HashMap(), null);
    }

    public static <T> T newInstance(Class<T> cls, Object object, CopyListener listener) {
        return (T)new Replicator().newInstance(cls, object, new HashMap(), listener);
    }

    public static <T> T copyInstance(T target, Object object) {
        new Replicator().copy(target, object, new HashMap(), null);
        return target;
    }

    public static <T> T copyInstance(T target, Object object, CopyListener listener) {
        new Replicator().copy(target, object, new HashMap(), listener);
        return target;
    }

    public static boolean compare(Object target, Object object) {
        return new Replicator().compare(target, object);
    }

    static {
        convertibleTypes.add(Boolean.TYPE);
        convertibleTypes.add(Boolean.class);
        convertibleTypes.add(Double.TYPE);
        convertibleTypes.add(Double.class);
        convertibleTypes.add(Float.TYPE);
        convertibleTypes.add(Float.class);
        convertibleTypes.add(Integer.TYPE);
        convertibleTypes.add(Integer.class);
        convertibleTypes.add(Long.TYPE);
        convertibleTypes.add(Long.class);
        convertibleTypes.add(Short.TYPE);
        convertibleTypes.add(Short.class);
        convertibleTypes.add(BigDecimal.class);
        convertibleTypes.add(BigInteger.class);
        securityManager = new PrivateSecurityManager();
        methodPropertyDescriptors = CacheBuilder.newBuilder().maximumSize(10000L).initialCapacity(500).concurrencyLevel(Provision.cacheBuilderConcurrencyLevel.intValue()).build((CacheLoader)new CacheLoader<Method, PropertyDescriptor>(){

            public PropertyDescriptor load(Method method) throws IntrospectionException {
                String property;
                String name = method.getName();
                Parameter[] parameters = method.getParameters();
                if (name.startsWith("set")) {
                    if (parameters.length != 1) {
                        throw new IllegalArgumentException("" + method.getName() + " is not a setter");
                    }
                    property = name.substring(3);
                } else if (name.startsWith("get")) {
                    if (parameters.length != 0) {
                        throw new IllegalArgumentException("" + method.getName() + " is not a getter");
                    }
                    property = name.substring(3);
                } else if (name.startsWith("is")) {
                    if (parameters.length != 0) {
                        throw new IllegalArgumentException("" + method.getName() + " is not a getter");
                    }
                    property = name.substring(2);
                } else {
                    throw new IllegalArgumentException("" + method.getName() + " is not an property accessor");
                }
                boolean lowerCase = true;
                if (property.length() > 1 && Character.isUpperCase(property.charAt(1))) {
                    lowerCase = false;
                }
                if (lowerCase) {
                    property = property.substring(0, 1).toLowerCase(Locale.ENGLISH) + property.substring(1);
                }
                return new PropertyDescriptor(property, method.getDeclaringClass());
            }
        });
        propertyDescriptors = CacheBuilder.newBuilder().maximumSize(10000L).initialCapacity(500).concurrencyLevel(Provision.cacheBuilderConcurrencyLevel.intValue()).build((CacheLoader)new CacheLoader<Pair<Class, String>, PropertyDescriptor>(){

            public PropertyDescriptor load(Pair<Class, String> key) throws Exception {
                PropertyDescriptor descriptor;
                Class cls = key.key();
                String property = key.value();
                try {
                    descriptor = new PropertyDescriptor(property, cls, "is" + TextSubstitution.capitalize(property), null);
                }
                catch (IntrospectionException e) {
                    throw new SystemException(cls.getName() + "." + property, e);
                }
                return descriptor;
            }
        });
        parametrizedTypes = CacheBuilder.newBuilder().maximumSize(10000L).initialCapacity(100).concurrencyLevel(Provision.cacheBuilderConcurrencyLevel.intValue()).build((CacheLoader)new CacheLoader<Class, Type[]>(){

            public Type[] load(Class clazz) throws Exception {
                Class cls = clazz;
                Type[] types = null;
                while (!cls.equals(Object.class)) {
                    try {
                        Type genericSuper = cls.getGenericSuperclass();
                        if (genericSuper instanceof ParameterizedType) {
                            ParameterizedType parametrizedType = (ParameterizedType)genericSuper;
                            types = parametrizedType.getActualTypeArguments();
                            break;
                        }
                    }
                    catch (Exception th) {
                        logger.warn(th.getMessage(), th);
                    }
                    cls = cls.getSuperclass();
                }
                if (types == null) {
                    throw new IllegalArgumentException("No parametrized types found");
                }
                return types;
            }
        });
        logger = Logger.getLogger();
    }

    public static class Replicator {
        private Map<Class, Map<String, PropertyDescriptor>> targetPropertiesDescriptor = new HashMap<Class, Map<String, PropertyDescriptor>>();
        private Map<Class, PropertyDescriptor[]> propertyDescriptors = new HashMap<Class, PropertyDescriptor[]>();

        private synchronized Map<String, PropertyDescriptor> getTargetProperties(Class cls) {
            return this.targetPropertiesDescriptor.computeIfAbsent(cls, key -> {
                PropertyDescriptor[] props;
                HashMap<String, PropertyDescriptor> descriptors = new HashMap<String, PropertyDescriptor>();
                for (PropertyDescriptor prop : props = Reflection.getBeanInfo(key).getPropertyDescriptors()) {
                    descriptors.put(prop.getName(), prop);
                }
                return descriptors;
            });
        }

        private synchronized PropertyDescriptor[] getPropertyDescriptors(Class cls) {
            return this.propertyDescriptors.computeIfAbsent(cls, key -> Reflection.getBeanInfo(key).getPropertyDescriptors());
        }

        public synchronized Map<Class, Map<String, PropertyDescriptor>> getTargetPropertiesDescriptor() {
            return this.targetPropertiesDescriptor;
        }

        public synchronized void setTargetPropertiesDescriptor(Map<Class, Map<String, PropertyDescriptor>> targetPropertiesDescriptor) {
            this.targetPropertiesDescriptor = targetPropertiesDescriptor;
        }

        public synchronized Map<Class, PropertyDescriptor[]> getPropertyDescriptors() {
            return this.propertyDescriptors;
        }

        public synchronized void setPropertyDescriptors(Map<Class, PropertyDescriptor[]> propertyDescriptors) {
            this.propertyDescriptors = propertyDescriptors;
        }

        public <T> T newInstance(Class<T> cls, Object object) {
            return new Replicator().newInstance(cls, object, new HashMap<Integer, Object>(), null);
        }

        public <T> T newInstance(Class<T> cls, Object object, CopyListener listener) {
            return new Replicator().newInstance(cls, object, new HashMap<Integer, Object>(), listener);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private <T> T newInstance(Type toType, Object object, Map<Integer, Object> seen, CopyListener listener) {
            if (object == null) {
                return null;
            }
            Object buildin = null;
            if (toType instanceof Class && (buildin = this.convertBuiltinType((Class)toType, object)) != null) {
                return (T)buildin;
            }
            Integer hashCode = null;
            if (!object.getClass().isPrimitive() && seen.get(hashCode = Integer.valueOf(System.identityHashCode(object))) != null) {
                return (T)seen.get(hashCode);
            }
            Object target = null;
            if (toType instanceof Class) {
                Class cls = (Class)toType;
                if (Enum.class.isAssignableFrom((Class)toType)) {
                    target = Enum.valueOf(cls, object.toString());
                } else if (Enum.class.isAssignableFrom(object.getClass()) && String.class.isAssignableFrom(cls)) {
                    target = ((Enum)object).name();
                } else if (Collection.class.isAssignableFrom(cls)) {
                    Collection collection = this.newCollection(cls);
                    target = collection;
                    if (!(object instanceof Collection)) throw new IllegalStateException("Do not know how to convert " + object.getClass() + " to " + toType);
                    Collection c = (Collection)object;
                    for (Object o : c) {
                        collection.add(o);
                    }
                } else {
                    try {
                        target = cls.newInstance();
                    }
                    catch (Exception e) {
                        throw new SystemException(e);
                    }
                    this.copy(target, object, seen, listener);
                }
            } else {
                ParameterizedType parametrized = (ParameterizedType)toType;
                Class enclosedType = (Class)parametrized.getRawType();
                Type type = parametrized.getActualTypeArguments()[0];
                if (Collection.class.isAssignableFrom(enclosedType)) {
                    Collection collection = this.newCollection(enclosedType);
                    target = collection;
                    if (!(object instanceof Collection)) throw new IllegalStateException("Do not know how to convert " + object.getClass() + " to " + toType);
                    Collection c = (Collection)object;
                    for (Object o : c) {
                        T converted = this.newInstance(type, o, seen, listener);
                        collection.add(converted);
                    }
                } else {
                    try {
                        target = enclosedType.newInstance();
                    }
                    catch (Exception e) {
                        throw new SystemException(e);
                    }
                    this.copy(target, object, seen, listener);
                }
            }
            if (hashCode == null) return (T)target;
            seen.put(hashCode, target);
            return (T)target;
        }

        protected Collection newCollection(Class cls) {
            AbstractCollection collection = null;
            collection = List.class.isAssignableFrom(cls) ? new ArrayList() : (Set.class.isAssignableFrom(cls) ? new LinkedHashSet() : new ArrayList());
            return collection;
        }

        protected Object convertBuiltinType(Class type, Object object) {
            if (String.class.isAssignableFrom(type)) {
                return object.toString();
            }
            if (!convertibleTypes.contains(type)) {
                return null;
            }
            if (type == Boolean.TYPE || type == Boolean.class) {
                return new Boolean(object.toString());
            }
            if (type == Double.TYPE || type == Double.class) {
                return new Double(object.toString());
            }
            if (type == Float.TYPE || type == Float.class) {
                return new Float(object.toString());
            }
            if (type == Integer.TYPE || type == Integer.class) {
                return new Integer(object.toString());
            }
            if (type == Long.TYPE || type == Long.class) {
                return new Long(object.toString());
            }
            if (type == Short.TYPE || type == Short.class) {
                return new Short(object.toString());
            }
            if (type == BigDecimal.class) {
                return new BigDecimal(object.toString());
            }
            if (type == BigInteger.class) {
                return new BigInteger(object.toString());
            }
            return null;
        }

        public void copy(Object target, Object object, CopyListener copyListener) {
            this.copy(target, object, new HashMap<Integer, Object>(), copyListener);
        }

        public void copy(Object target, Object object) {
            this.copy(target, object, new HashMap<Integer, Object>(), null);
        }

        private void copy(Object target, Object object, Map<Integer, Object> seen, CopyListener copyListener) {
            if (target == null || object == null) {
                return;
            }
            for (PropertyDescriptor prop : this.getPropertyDescriptors(object.getClass())) {
                Method getter;
                Method setter;
                PropertyDescriptor targetDesc;
                if (prop.getReadMethod() == null || (targetDesc = this.getTargetProperties(target.getClass()).get(prop.getName())) == null || (setter = targetDesc.getWriteMethod()) == null || setter.getAnnotation(DoNotAccept.class) != null || (getter = targetDesc.getReadMethod()) != null && getter.getAnnotation(DoNotAccept.class) != null) continue;
                try {
                    boolean annotated;
                    boolean bl = annotated = prop.getReadMethod().getAnnotation(DoNotCopy.class) != null;
                    if (!annotated && prop.getWriteMethod() != null) {
                        boolean bl2 = annotated = prop.getWriteMethod().getAnnotation(DoNotCopy.class) != null;
                    }
                    if (annotated) continue;
                    try {
                        boolean handled = false;
                        if (copyListener != null) {
                            handled = copyListener.copy(target, targetDesc, object, prop);
                        }
                        if (handled) continue;
                        Object value = prop.getReadMethod().invoke(object, new Object[0]);
                        if (!(value instanceof Collection) && setter.getParameterTypes()[0].isAssignableFrom(prop.getReadMethod().getReturnType())) {
                            setter.invoke(target, value);
                            continue;
                        }
                        try {
                            Object converted = this.newInstance(setter.getGenericParameterTypes()[0], value, seen, copyListener);
                            setter.invoke(target, converted);
                        }
                        catch (Exception ex) {
                            logger.warn("Error copying " + value + " to " + setter.getDeclaringClass() + "::" + setter.getName(), ex);
                        }
                    }
                    catch (PropertyVetoException ex) {
                        Logger.suppress(ex);
                    }
                }
                catch (Exception e) {
                    throw new SystemException(e);
                }
            }
        }

        public boolean compare(Object target, Object object) {
            Stack<String> stack = new Stack<String>();
            if (target != null) {
                stack.push(target.getClass().getName());
            }
            return this.compare(target, object, new HashSet<String>(), stack);
        }

        private boolean compare(Object target, Object object, Set<String> seen, Stack<String> stack) {
            if (target == null && object == null) {
                return true;
            }
            if (target == null || object == null) {
                return false;
            }
            int hashCode = System.identityHashCode(target);
            int hashCode2 = System.identityHashCode(object);
            String compared = Integer.toString(hashCode) + ":" + hashCode2;
            if (seen.contains(compared)) {
                return true;
            }
            if (target.getClass().isAssignableFrom(object.getClass())) {
                if (!target.equals(object)) {
                    if (logger.isDebugEnabled()) {
                        StringBuilder builder = new StringBuilder();
                        builder.append("Comparison failed at ");
                        boolean first = true;
                        for (String element : stack) {
                            if (first) {
                                first = false;
                            } else {
                                builder.append(".");
                            }
                            builder.append(element);
                        }
                        logger.debug(builder.toString());
                    }
                    return false;
                }
                return true;
            }
            if (!object.getClass().isPrimitive()) {
                seen.add(compared);
            }
            for (PropertyDescriptor prop : this.getPropertyDescriptors(target.getClass())) {
                if (prop.getReadMethod() == null || "class".equals(prop.getName())) continue;
                try {
                    boolean annotated;
                    boolean bl = annotated = prop.getReadMethod().getAnnotation(DoNotCopy.class) != null;
                    if (!annotated && prop.getWriteMethod() != null) {
                        boolean bl2 = annotated = prop.getWriteMethod().getAnnotation(DoNotCopy.class) != null;
                    }
                    if (annotated) continue;
                    Method objectGetter = null;
                    try {
                        PropertyDescriptor objectProp = new PropertyDescriptor(prop.getName(), object.getClass(), "is" + Replicator.capitalize(prop.getName()), null);
                        objectGetter = objectProp.getReadMethod();
                    }
                    catch (IntrospectionException e) {
                        Logger.suppress(e);
                    }
                    if (objectGetter == null) continue;
                    Object value = objectGetter.invoke(object, new Object[0]);
                    Object targetFieldValue = prop.getReadMethod().invoke(target, new Object[0]);
                    stack.push(prop.getName());
                    if (!this.compare(targetFieldValue, value, seen, stack)) {
                        return false;
                    }
                    stack.pop();
                }
                catch (Exception e) {
                    throw new SystemException(e);
                }
            }
            return true;
        }

        public static String capitalize(String name) {
            return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
        }
    }

    static final class PrivateSecurityManager
    extends SecurityManager {
        PrivateSecurityManager() {
        }

        @Override
        protected Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

