/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.util.monitor;

import java.util.concurrent.ExecutorService;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.util.monitor.TimeoutListener;

public class TimeoutMonitor {
    long timeout = -1L;
    @Inject(optional=true)
    ExecutorService threadPool;

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    public void monitor(TimeoutListener listener) {
        long initialTimeout;
        if (listener.getTimeout() < 0L) {
            return;
        }
        long l = initialTimeout = listener.getTimeout() == 0L ? this.timeout : listener.getTimeout();
        if (initialTimeout > 0L) {
            Monitor monitor = new Monitor(listener);
            if (this.threadPool != null) {
                this.threadPool.execute(monitor);
            } else {
                Thread thread = new Thread(monitor);
                thread.setDaemon(true);
                thread.start();
            }
        }
    }

    protected boolean rollback(TimeoutListener listener) {
        if (listener.isOpen()) {
            listener.onTimeout();
            return true;
        }
        return false;
    }

    class Monitor
    implements Runnable {
        TimeoutListener listener;

        Monitor(TimeoutListener listener) {
            this.listener = listener;
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            long sleep = 100L;
            while (sleep >= 0L) {
                long t;
                long l = t = this.listener.getTimeout() == 0L ? TimeoutMonitor.this.timeout : this.listener.getTimeout();
                if (!this.listener.isOpen()) break;
                if (System.currentTimeMillis() - start > t) {
                    if (!TimeoutMonitor.this.rollback(this.listener)) continue;
                    break;
                }
                if (t - (System.currentTimeMillis() - start) < 100L) {
                    sleep = t - (System.currentTimeMillis() - start);
                }
                if (sleep < 100L && (sleep = t - (System.currentTimeMillis() - start) - 10L) < 10L) {
                    sleep = t - (System.currentTimeMillis() - start) - 1L;
                }
                try {
                    if (sleep < 0L) continue;
                    Thread.sleep(sleep);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            TimeoutMonitor.this.rollback(this.listener);
        }
    }
}

