/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources.plugin;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class PluginPath<T> {
    PluginPath parent;
    private Class<T> type;
    private String name;
    private String toString;
    private int hash = 0;
    private LinkedList<PluginPath> path;

    protected PluginPath(Class<T> cls, String name) {
        this.type = cls;
        this.name = name;
    }

    public static <T> PluginPath<T> of(Class<T> cls) {
        return new PluginPath<T>(cls, null);
    }

    public static <T> PluginPath<T> of(Class<T> cls, String name) {
        return new PluginPath<T>(cls, name);
    }

    public Class<T> getType() {
        return this.type;
    }

    public void setType(Class<T> type) {
        this.type = type;
        this.toString = null;
        this.hash = 0;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.toString = null;
        this.hash = 0;
    }

    public <R> PluginPath<R> and(Class<R> cls, String name) {
        PluginPath<R> child = new PluginPath<R>(cls, name);
        child.parent = this;
        return child;
    }

    public <R> PluginPath<R> and(Class<R> cls) {
        PluginPath<R> child = new PluginPath<R>(cls, null);
        child.parent = this;
        return child;
    }

    public List<PluginPath> list() {
        if (this.path != null) {
            return this.path;
        }
        this.path = new LinkedList();
        PluginPath p = this;
        while (p != null) {
            this.path.addFirst(p);
            p = p.parent;
        }
        return this.path;
    }

    public String path() {
        if (this.toString != null) {
            return this.toString;
        }
        StringBuilder builder = new StringBuilder();
        List<PluginPath> list = this.list();
        boolean first = true;
        for (PluginPath p : list) {
            if (first) {
                first = false;
            } else {
                builder.append("/");
            }
            builder.append(p.getType().getName());
            if (p.getName() == null) continue;
            builder.append("/").append(p.getName());
        }
        this.toString = builder.toString();
        return this.toString;
    }

    public String toString() {
        return this.path();
    }

    public int hashCode() {
        if (this.hash == 0) {
            List<PluginPath> list = this.list();
            int result = 1;
            for (PluginPath p : list) {
                result = 31 * result + (p == null ? 0 : Objects.hash(p.type, this.name));
            }
            this.hash = result;
        }
        return this.hash;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PluginPath)) {
            return false;
        }
        PluginPath p = (PluginPath)object;
        List<PluginPath> l1 = this.list();
        List<PluginPath> l2 = p.list();
        if (l1.size() == l2.size()) {
            for (int i = 0; i < l1.size(); ++i) {
                PluginPath p1 = l1.get(i);
                PluginPath p2 = l2.get(i);
                if (!(p1 != null && p2 != null ? !Objects.equals(p1.name, p2.name) || !Objects.equals(p1.type, p2.type) : p1 != p2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

