/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.util;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class AsciiArt {
    private AsciiArt() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generate(String text, int fontSize) {
        Graphics graphics = null;
        StringBuilder builder = new StringBuilder();
        try {
            BufferedImage image = new BufferedImage(1, 1, 1);
            Font font = new Font("Monospaced", 0, fontSize);
            int width = 0;
            int height = 0;
            int desc = 0;
            try {
                graphics = image.createGraphics();
                graphics.setFont(font);
                width = graphics.getFontMetrics().stringWidth(text) + 5;
                height = graphics.getFontMetrics().getHeight();
                desc = graphics.getFontMetrics().getDescent();
            }
            finally {
                if (graphics != null) {
                    graphics.dispose();
                }
                graphics = null;
            }
            image = new BufferedImage(width, height, 1);
            graphics = image.createGraphics();
            graphics.setFont(font);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            ((Graphics2D)graphics).drawString(text, 5, height - desc);
            StringBuilder sb = new StringBuilder();
            int i = 0;
            for (int y = 0; y < height; ++y) {
                sb.setLength(0);
                for (int x = 0; x < width; ++x) {
                    sb.append(image.getRGB(x, y) == -16777216 ? " " : Character.valueOf(text.charAt(i++ % text.length())));
                }
                if (sb.toString().trim().isEmpty()) continue;
                builder.append(sb.toString());
                builder.append("\n");
            }
            graphics.dispose();
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
        }
        return builder.toString();
    }
}

