/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.actor.typed;

import akka.actor.PoisonPill;
import akka.actor.typed.ActorRef;
import akka.actor.typed.Scheduler;
import akka.actor.typed.javadsl.AskPattern;
import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import net.e6tech.elements.common.actor.typed.Guardian;
import net.e6tech.elements.common.util.SystemException;

public class Talk<T> {
    private long timeout;
    private Guardian guardian;
    private ActorRef<T> recipient;

    public Talk(Guardian guardian, ActorRef<T> recipient) {
        this.guardian = guardian;
        this.timeout = guardian.getTimeout();
        this.recipient = recipient;
    }

    public Talk<T> timeout(long timout) {
        this.timeout = timout;
        return this;
    }

    public <Res> CompletionStage<Res> ask(Function<ActorRef<Res>, T> msgFactory) {
        return AskPattern.ask(this.recipient, msgFactory::apply, (Duration)Duration.ofMillis(this.timeout), (Scheduler)this.guardian.getScheduler());
    }

    public <Res> Res askAndWait(Class<Res> retClass, Function<ActorRef<Res>, T> msgFactory) {
        return this.askAndWait(msgFactory);
    }

    public <Res> Res askAndWait(Function<ActorRef<Res>, T> msgFactory) {
        CompletionStage stage = AskPattern.ask(this.recipient, msgFactory::apply, (Duration)Duration.ofMillis(this.timeout), (Scheduler)this.guardian.getScheduler());
        try {
            return (Res)stage.toCompletableFuture().get();
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    public Talk<T> tell(T msg) {
        this.recipient.tell(msg);
        return this;
    }

    public void stop() {
        AskPattern.ask(this.recipient, (akka.japi.function.Function & Serializable)ref -> PoisonPill.getInstance(), (Duration)Duration.ofSeconds(10L), (Scheduler)this.guardian.getScheduler());
    }

    public CompletionStage<Void> async(Runnable runnable) {
        return this.guardian.async(runnable, this.timeout);
    }

    public <R> CompletionStage<R> async(Callable<R> callable) {
        return this.guardian.async(callable, this.timeout);
    }
}

