/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.actor.typed.worker;

import akka.actor.Status;
import akka.actor.typed.ActorRef;
import net.e6tech.elements.common.actor.typed.Receptor;
import net.e6tech.elements.common.actor.typed.Typed;
import net.e6tech.elements.common.actor.typed.worker.WorkEvents;

public class Worker
extends Receptor<WorkEvents, Worker> {
    private ActorRef<WorkEvents> pool;

    public Worker(ActorRef<WorkEvents> pool) {
        this.pool = pool;
    }

    @Typed
    private void run(WorkEvents.RunnableTask message) {
        try {
            message.getRunnable().run();
            if (message.getSender() != null) {
                message.getSender().tell((Object)new WorkEvents.Response());
            }
        }
        catch (Exception th) {
            if (message.getSender() != null) {
                message.getSender().tell((Object)new Status.Failure((Throwable)th));
            }
        }
        finally {
            this.pool.tell((Object)new WorkEvents.IdleWorker(this.getSelf()));
        }
    }

    @Typed
    private void call(WorkEvents.CallableTask message) {
        try {
            Object ret = message.getCallable().call();
            if (message.getSender() != null) {
                message.getSender().tell((Object)new WorkEvents.Response(ret));
            }
        }
        catch (Exception th) {
            if (message.getSender() != null) {
                message.getSender().tell((Object)new Status.Failure((Throwable)th));
            }
        }
        finally {
            this.pool.tell((Object)new WorkEvents.IdleWorker(this.getSelf()));
        }
    }
}

