/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.interceptor;

import net.e6tech.elements.common.interceptor.Interceptor;
import net.e6tech.elements.common.interceptor.InterceptorHandler;
import net.e6tech.elements.common.interceptor.InterceptorListener;
import net.e6tech.elements.common.interceptor.NewObject;
import net.e6tech.elements.common.util.SystemException;

public abstract class AbstractBuilder<T, B extends AbstractBuilder> {
    static final NewObject defaultNewObject = proxyClass -> {
        Object proxyObject;
        try {
            proxyObject = proxyClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        return proxyObject;
    };
    Interceptor interceptor;
    InterceptorHandler handler;
    InterceptorListener listener;
    ClassLoader classLoader;
    NewObject<T> newObject = defaultNewObject;

    public AbstractBuilder(Interceptor interceptor, InterceptorHandler handler) {
        this.interceptor = interceptor;
        this.handler = handler;
    }

    public B handler(InterceptorHandler handler) {
        this.handler = handler;
        return (B)this;
    }

    public B listener(InterceptorListener listener) {
        this.listener = listener;
        return (B)this;
    }

    public B classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return (B)this;
    }

    public B newObject(NewObject<T> newObject) {
        this.newObject = newObject;
        return (B)this;
    }

    public <U> U newObject(Class<U> proxyClass) {
        U proxyObject;
        try {
            proxyObject = proxyClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        return proxyObject;
    }

    public abstract T build();
}

