/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.interceptor;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

public class JoinClassLoader
extends ClassLoader {
    private ClassLoader[] delegateClassLoaders;

    public JoinClassLoader(ClassLoader parent, ClassLoader ... delegateClassLoaders) {
        super(parent);
        this.delegateClassLoaders = delegateClassLoaders;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        ByteBuffer byteCode;
        String path = name.replace('.', '/') + ".class";
        URL url = this.findResource(path);
        if (url == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            byteCode = this.loadResource(url);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
        return this.defineClass(name, byteCode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer loadResource(URL url) throws IOException {
        try (InputStream stream = null;){
            stream = url.openStream();
            int initialBufferCapacity = Math.min(262144, stream.available() + 1);
            initialBufferCapacity = initialBufferCapacity <= 2 ? 65536 : Math.max(initialBufferCapacity, 512);
            ByteBuffer buf = ByteBuffer.allocate(initialBufferCapacity);
            while (true) {
                int len;
                if (!buf.hasRemaining()) {
                    ByteBuffer newBuf = ByteBuffer.allocate(2 * buf.capacity());
                    buf.flip();
                    newBuf.put(buf);
                    buf = newBuf;
                }
                if ((len = stream.read(buf.array(), buf.position(), buf.remaining())) <= 0) break;
                buf.position(buf.position() + len);
            }
            buf.flip();
            ByteBuffer byteBuffer = buf;
            return byteBuffer;
        }
    }

    @Override
    protected URL findResource(String name) {
        for (ClassLoader delegate : this.delegateClassLoaders) {
            URL resource = delegate.getResource(name);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        ArrayList<URL> list = new ArrayList<URL>();
        for (ClassLoader delegate : this.delegateClassLoaders) {
            Enumeration<URL> enumeration = delegate.getResources(name);
            while (enumeration.hasMoreElements()) {
                list.add(enumeration.nextElement());
            }
        }
        return Collections.enumeration(list);
    }
}

