/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.logging;

import java.io.PrintStream;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.helpers.MessageFormatter;

public class ConsoleLogger
implements Logger {
    private PrintStream out = System.out;
    private boolean traceEnabled = false;
    private boolean debugEnabled = false;
    private boolean infoEnabled = true;
    private boolean warnEnabled = true;
    private boolean errorEnabled = true;

    public ConsoleLogger traceEnabled() {
        this.setTraceEnabled(true);
        return this;
    }

    public ConsoleLogger traceEnabled(boolean t) {
        this.setTraceEnabled(t);
        return this;
    }

    public ConsoleLogger debugEnabled() {
        this.setDebugEnabled(true);
        return this;
    }

    public ConsoleLogger debugEnabled(boolean t) {
        this.traceEnabled = t;
        return this;
    }

    public ConsoleLogger infoEnabled() {
        this.setInfoEnabled(true);
        return this;
    }

    public ConsoleLogger infoEnabled(boolean t) {
        this.setInfoEnabled(t);
        return this;
    }

    public ConsoleLogger warnEnabled() {
        this.setWarnEnabled(true);
        return this;
    }

    public ConsoleLogger warnEnabled(boolean t) {
        this.setWarnEnabled(t);
        return this;
    }

    public ConsoleLogger errorEnabled() {
        this.setErrorEnabled(true);
        return this;
    }

    public ConsoleLogger errorEnabled(boolean t) {
        this.setErrorEnabled(t);
        return this;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public void println(String msg) {
        if (this.out != null) {
            this.out.println(msg);
        }
    }

    public void println(String format, Object arg) {
        if (this.out != null) {
            this.out.println(MessageFormatter.format((String)format, (Object)arg).getMessage());
        }
    }

    public void println(String format, Object arg1, Object arg2) {
        if (this.out != null) {
            this.out.println(MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage());
        }
    }

    public void println(String format, Object ... arguments) {
        if (this.out != null) {
            this.out.println(MessageFormatter.arrayFormat((String)format, (Object[])arguments).getMessage());
        }
    }

    public void println(String msg, Throwable t) {
        if (this.out != null) {
            this.println(msg);
            if (t != null) {
                t.printStackTrace(this.out);
                this.out.println();
            }
        }
    }

    public void println(Marker marker, String msg) {
        this.println(marker + ": " + msg);
    }

    public void println(Marker marker, String format, Object arg) {
        this.println(marker + ": " + format, arg);
    }

    public void println(Marker marker, String format, Object arg1, Object arg2) {
        this.println(marker + ": " + format, arg1, arg2);
    }

    public void println(Marker marker, String format, Object ... arguments) {
        this.println(marker + ": " + format, arguments);
    }

    public void println(Marker marker, String msg, Throwable t) {
        this.println(marker + ": " + msg, t);
    }

    public String getName() {
        return "ConsoleLogger";
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public void setTraceEnabled(boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
    }

    public void trace(String msg) {
        if (this.isTraceEnabled()) {
            this.println(msg);
        }
    }

    public void trace(String format, Object arg) {
        if (this.isTraceEnabled()) {
            this.println(format, arg);
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            this.println(format, arg1, arg2);
        }
    }

    public void trace(String format, Object ... arguments) {
        if (this.isTraceEnabled()) {
            this.println(format, arguments);
        }
    }

    public void trace(String msg, Throwable t) {
        if (this.isTraceEnabled()) {
            this.println(msg, t);
        }
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.isTraceEnabled();
    }

    public void trace(Marker marker, String msg) {
        this.println(marker, msg);
    }

    public void trace(Marker marker, String format, Object arg) {
        this.println(marker, format, arg);
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.println(marker, format, arg1, arg2);
    }

    public void trace(Marker marker, String format, Object ... arguments) {
        this.println(marker, format, arguments);
    }

    public void trace(Marker marker, String msg, Throwable t) {
        this.println(marker, msg, t);
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public void setDebugEnabled(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
    }

    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            this.println(msg);
        }
    }

    public void debug(String format, Object arg) {
        if (this.isDebugEnabled()) {
            this.println(format, arg);
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.println(format, arg1, arg2);
        }
    }

    public void debug(String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            this.println(format, arguments);
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.isDebugEnabled()) {
            this.println(msg, t);
        }
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.isDebugEnabled();
    }

    public void debug(Marker marker, String msg) {
        if (this.isDebugEnabled()) {
            this.println(marker, msg);
        }
    }

    public void debug(Marker marker, String format, Object arg) {
        if (this.isDebugEnabled()) {
            this.println(marker, format, arg);
        }
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.println(marker, format, arg1, arg2);
        }
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            this.println(marker, format, arguments);
        }
    }

    public void debug(Marker marker, String msg, Throwable t) {
        if (this.isDebugEnabled()) {
            this.println(marker, msg, t);
        }
    }

    public boolean isInfoEnabled() {
        return this.infoEnabled;
    }

    public void setInfoEnabled(boolean infoEnabled) {
        this.infoEnabled = infoEnabled;
    }

    public void info(String msg) {
        if (this.isInfoEnabled()) {
            this.println(msg);
        }
    }

    public void info(String format, Object arg) {
        if (this.isInfoEnabled()) {
            this.println(format, arg);
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.println(format, arg1, arg2);
        }
    }

    public void info(String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            this.println(format, arguments);
        }
    }

    public void info(String msg, Throwable t) {
        if (this.isInfoEnabled()) {
            this.println(msg, t);
        }
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.isInfoEnabled();
    }

    public void info(Marker marker, String msg) {
        if (this.isInfoEnabled()) {
            this.println(marker, msg);
        }
    }

    public void info(Marker marker, String format, Object arg) {
        if (this.isInfoEnabled()) {
            this.println(marker, format, arg);
        }
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.println(marker, format, arg1, arg2);
        }
    }

    public void info(Marker marker, String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            this.println(marker, format, arguments);
        }
    }

    public void info(Marker marker, String msg, Throwable t) {
        if (this.isInfoEnabled()) {
            this.println(marker, msg, t);
        }
    }

    public boolean isWarnEnabled() {
        return this.warnEnabled;
    }

    public void setWarnEnabled(boolean warnEnabled) {
        this.warnEnabled = warnEnabled;
    }

    public void warn(String msg) {
        if (this.isWarnEnabled()) {
            this.println(msg);
        }
    }

    public void warn(String format, Object arg) {
        if (this.isWarnEnabled()) {
            this.println(format, arg);
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            this.println(format, arg1, arg2);
        }
    }

    public void warn(String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            this.println(format, arguments);
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            this.println(msg, t);
        }
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.isWarnEnabled();
    }

    public void warn(Marker marker, String msg) {
        if (this.isWarnEnabled()) {
            this.println(marker, msg);
        }
    }

    public void warn(Marker marker, String format, Object arg) {
        if (this.isWarnEnabled()) {
            this.println(marker, format, arg);
        }
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            this.println(marker, format, arg1, arg2);
        }
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            this.println(marker, format, arguments);
        }
    }

    public void warn(Marker marker, String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            this.println(marker, msg, t);
        }
    }

    public boolean isErrorEnabled() {
        return this.errorEnabled;
    }

    public void setErrorEnabled(boolean errorEnabled) {
        this.errorEnabled = errorEnabled;
    }

    public void error(String msg) {
        if (this.isErrorEnabled()) {
            this.println(msg);
        }
    }

    public void error(String format, Object arg) {
        if (this.isErrorEnabled()) {
            this.println(format, arg);
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.println(format, arg1, arg2);
        }
    }

    public void error(String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            this.println(format, arguments);
        }
    }

    public void error(String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            this.println(msg, t);
        }
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.isErrorEnabled();
    }

    public void error(Marker marker, String msg) {
        if (this.isErrorEnabled()) {
            this.println(marker, msg);
        }
    }

    public void error(Marker marker, String format, Object arg) {
        if (this.isErrorEnabled()) {
            this.println(marker, format, arg);
        }
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.println(marker, format, arg1, arg2);
        }
    }

    public void error(Marker marker, String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            this.println(marker, format, arguments);
        }
    }

    public void error(Marker marker, String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            this.println(marker, msg, t);
        }
    }
}

