/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.reflection;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.reflection.Primitives;
import net.e6tech.elements.common.util.SystemException;

public class ObjectConverter {
    public static final ObjectMapper mapper = new ObjectMapper();

    public static Class loadClass(ClassLoader loader, String name) throws ClassNotFoundException {
        if (Primitives.isPrimitive(name)) {
            return Primitives.get(name);
        }
        return loader.loadClass(name);
    }

    public Object convert(Object from, Method getterOrSetter, InstanceCreationListener listener) throws IOException {
        Type returnType = getterOrSetter.getGenericReturnType();
        if (!returnType.equals(Void.TYPE)) {
            if (getterOrSetter.getParameterTypes().length != 0) {
                throw new IllegalArgumentException("Method " + getterOrSetter.getName() + " must be a getter");
            }
            return this.convert(from, returnType, listener);
        }
        Type[] parameters = getterOrSetter.getGenericParameterTypes();
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Method " + getterOrSetter.getName() + " must be a setter");
        }
        Type argumentType = parameters[0];
        return this.convert(from, argumentType, listener);
    }

    public Object convert(Object from, Field field, InstanceCreationListener listener) throws IOException {
        return this.convert(from, field.getGenericType(), listener);
    }

    public Object convert(Object from, Type toType, InstanceCreationListener listener) throws IOException {
        Object converted;
        if (toType instanceof Class) {
            converted = this.convert(from, (Class)toType, listener);
        } else {
            ParameterizedType parametrized = (ParameterizedType)toType;
            Class enclosedType = (Class)parametrized.getRawType();
            Type type = parametrized.getActualTypeArguments()[0];
            if (type instanceof Class) {
                Class elementType = (Class)type;
                converted = Collection.class.isAssignableFrom(enclosedType) ? this.convertCollection((Collection)from, enclosedType, elementType, listener) : this.convert(from, enclosedType, listener);
            } else if (type instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)type;
                if (ptype.getRawType() instanceof Class) {
                    Class elementType = (Class)ptype.getRawType();
                    converted = Collection.class.isAssignableFrom(enclosedType) ? this.convertCollection((Collection)from, enclosedType, elementType, listener) : this.convert(from, enclosedType, listener);
                } else {
                    converted = this.convert(from, enclosedType, listener);
                }
            } else {
                converted = this.convert(from, enclosedType, listener);
            }
        }
        return converted;
    }

    private Object convert(Object val, Class toType, InstanceCreationListener instanceCreation) throws IOException {
        Object value = val;
        Class<?> fromType = value.getClass();
        if (toType.isArray()) {
            if (fromType.isArray() && fromType.getComponentType().equals(toType.getComponentType())) {
                return value;
            }
            if (value instanceof Collection) {
                Collection coll = (Collection)value;
                Object array = Array.newInstance(toType.getComponentType(), coll.size());
                Iterator iterator = coll.iterator();
                int index = 0;
                while (iterator.hasNext()) {
                    Object member = iterator.next();
                    Array.set(array, index, this.convert(member, toType.getComponentType(), instanceCreation));
                    ++index;
                }
                return array;
            }
            throw new IllegalArgumentException("Cannot convert " + fromType + " to " + toType);
        }
        if (toType.isPrimitive() || fromType.isPrimitive()) {
            boolean needConversion = toType.equals(fromType) ? false : (toType.isPrimitive() ? this.shouldConvertPrimitive(toType, fromType) : this.shouldConvertPrimitive(fromType, toType));
            if (!needConversion) {
                return value;
            }
        } else {
            if (toType.isAssignableFrom(fromType)) {
                return value;
            }
            if (value instanceof String && !toType.isAssignableFrom(Class.class)) {
                try {
                    String str = mapper.writeValueAsString(value);
                    value = mapper.readValue(str, toType);
                    return value;
                }
                catch (Exception e) {
                    Logger.suppress(e);
                    try {
                        Class<?> cls = this.getClass().getClassLoader().loadClass((String)value);
                        value = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        if (instanceCreation != null) {
                            instanceCreation.instanceCreated(value, toType, value);
                        }
                        return value;
                    }
                    catch (Exception e1) {
                        throw new SystemException(e1);
                    }
                }
            }
        }
        String str = mapper.writeValueAsString(value);
        return mapper.readValue(str, toType);
    }

    private Collection convertCollection(Collection value, Class<? extends Collection> collectionType, Class elementType, InstanceCreationListener instanceCreation) throws IOException {
        CollectionType ctype = TypeFactory.defaultInstance().constructCollectionType(collectionType, elementType);
        String str = mapper.writeValueAsString((Object)value);
        Collection converted = (Collection)mapper.readValue(str, (JavaType)ctype);
        if (instanceCreation != null) {
            Iterator iter1 = value.iterator();
            Iterator iter2 = converted.iterator();
            while (iter1.hasNext() && iter2.hasNext()) {
                instanceCreation.instanceCreated(iter1.hasNext(), elementType, iter2.next());
            }
        }
        return converted;
    }

    protected boolean shouldConvertPrimitive(Class c1, Class c2) {
        return !(c1.equals(Boolean.TYPE) && Boolean.class.equals((Object)c2) || c1.equals(Character.TYPE) && Character.class.equals((Object)c2) || c1.equals(Byte.TYPE) && Byte.class.equals((Object)c2) || c1.equals(Short.TYPE) && Short.class.equals((Object)c2) || c1.equals(Integer.TYPE) && Integer.class.equals((Object)c2) || c1.equals(Long.TYPE) && Long.class.equals((Object)c2) || c1.equals(Float.TYPE) && Float.class.equals((Object)c2) || c1.equals(Double.TYPE) && Double.class.equals((Object)c2));
    }

    static {
        mapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    }

    @FunctionalInterface
    public static interface InstanceCreationListener {
        public void instanceCreated(Object var1, Class var2, Object var3);
    }
}

