/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources;

import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.function.Function;
import net.e6tech.elements.common.notification.NotificationCenter;
import net.e6tech.elements.common.resources.ResourceManager;
import net.e6tech.elements.common.util.SystemException;

public interface ResourcePool {
    public ResourceManager getResourceManager();

    default public <T> T getBean(String name) {
        return this.getResourceManager().getBean(name);
    }

    default public <T> T getBean(Class<T> cls) {
        return this.getResourceManager().getBean(cls);
    }

    default public NotificationCenter getNotificationCenter() {
        return this.getResourceManager().getNotificationCenter();
    }

    public <T> T bind(Class<T> var1, T var2);

    default public <T> T bind(T resource) {
        return (T)this.bind(resource.getClass(), resource);
    }

    public <T> T rebind(Class<T> var1, T var2);

    default public <T> T rebind(T resource) {
        return (T)this.rebind(resource.getClass(), resource);
    }

    public <T> T unbind(Class<T> var1);

    public void bindClass(Class var1, Class var2);

    public <T> T bindNamedInstance(Class<T> var1, String var2, T var3);

    public <T> T rebindNamedInstance(Class<T> var1, String var2, T var3);

    public <T> T inject(T var1);

    default public <T> T newInstance(Class<T> cls) {
        try {
            T instance = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.inject(instance);
            return instance;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new SystemException(e);
        }
        catch (InvocationTargetException e) {
            throw new SystemException(e.getTargetException());
        }
    }

    default public <T> T findById(Class<T> cls, Object id) {
        return null;
    }

    default public <T, U> U mapById(Class<T> cls, Object id, Function<T, U> mapper) {
        return Optional.ofNullable(this.findById(cls, id)).map(mapper).orElse(null);
    }
}

