/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources;

import java.util.concurrent.Callable;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.util.function.BiConsumerWithException;
import net.e6tech.elements.common.util.function.BiFunctionWithException;
import net.e6tech.elements.common.util.function.ConsumerWithException;
import net.e6tech.elements.common.util.function.FunctionWithException;
import net.e6tech.elements.common.util.function.RunnableWithException;
import net.e6tech.elements.common.util.function.TriConsumerWithException;
import net.e6tech.elements.common.util.function.TriFunctionWithException;

@FunctionalInterface
public interface Transactional {
    public <T extends Resources> T open();

    default public <R> R apply(Callable<R> callable) {
        return this.commit(callable);
    }

    default public <R> R call(Callable<R> callable) {
        return this.commit(callable);
    }

    default public <R> R commit(Callable<R> callable) {
        Resources resources = this.open();
        resources.submit(r -> callable.call());
        return resources.commit();
    }

    default public void run(RunnableWithException runnable) {
        this.commit(runnable);
    }

    default public void accept(RunnableWithException runnable) {
        this.commit(runnable);
    }

    default public void commit(RunnableWithException runnable) {
        Object resources = this.open();
        ((Resources)resources).submit(r -> runnable.run());
        ((Resources)resources).commit();
    }

    default public <T, R, E extends Exception> R apply(Class<T> cls, FunctionWithException<T, R, E> function) {
        return this.commit(cls, function);
    }

    default public <T, R, E extends Exception> R commit(Class<T> cls, FunctionWithException<T, R, E> function) {
        Resources resources = this.open();
        resources.submit(r -> function.apply(r.getInstance(cls)));
        return resources.commit();
    }

    default public <T, E extends Exception> void accept(Class<T> cls, ConsumerWithException<T, E> consumer) {
        this.commit(cls, consumer);
    }

    default public <T, E extends Exception> void commit(Class<T> cls, ConsumerWithException<T, E> consumer) {
        T resources = this.open();
        ((Resources)resources).submit(r -> consumer.accept(r.getInstance(cls)));
        ((Resources)resources).commit();
    }

    default public <S, T, R, E extends Exception> R apply(Class<S> cls, Class<T> cls2, BiFunctionWithException<S, T, R, E> function) {
        return this.commit(cls, cls2, function);
    }

    default public <S, T, R, E extends Exception> R commit(Class<S> cls, Class<T> cls2, BiFunctionWithException<S, T, R, E> function) {
        Resources resources = this.open();
        resources.submit(r -> function.apply(r.getInstance(cls), r.getInstance(cls2)));
        return resources.commit();
    }

    default public <S, T, E extends Exception> void accept(Class<S> cls, Class<T> cls2, BiConsumerWithException<S, T, E> consumer) {
        this.commit(cls, cls2, consumer);
    }

    default public <S, T, E extends Exception> void commit(Class<S> cls, Class<T> cls2, BiConsumerWithException<S, T, E> consumer) {
        T resources = this.open();
        ((Resources)resources).submit(r -> consumer.accept(r.getInstance(cls), r.getInstance(cls2)));
        ((Resources)resources).commit();
    }

    default public <S, T, U, R, E extends Exception> R apply(Class<S> cls, Class<T> cls2, Class<U> cls3, TriFunctionWithException<S, T, U, R, E> function) {
        return this.commit(cls, cls2, cls3, function);
    }

    default public <S, T, U, R, E extends Exception> R commit(Class<S> cls, Class<T> cls2, Class<U> cls3, TriFunctionWithException<S, T, U, R, E> function) {
        Resources resources = this.open();
        resources.submit(r -> function.apply(r.getInstance(cls), r.getInstance(cls2), r.getInstance(cls3)));
        return resources.commit();
    }

    default public <S, T, U, E extends Exception> void accept(Class<S> cls, Class<T> cls2, Class<U> cls3, TriConsumerWithException<S, T, U, E> consumer) {
        this.commit(cls, cls2, cls3, consumer);
    }

    default public <S, T, U, E extends Exception> void commit(Class<S> cls, Class<T> cls2, Class<U> cls3, TriConsumerWithException<S, T, U, E> consumer) {
        T resources = this.open();
        ((Resources)resources).submit(r -> consumer.accept(r.getInstance(cls), r.getInstance(cls2), r.getInstance(cls3)));
        ((Resources)resources).commit();
    }

    default public <E extends Exception> void accept(Class[] classes, ConsumerWithException<Object[], E> consumer) {
        this.commit(classes, consumer);
    }

    default public <E extends Exception> void commit(Class[] classes, ConsumerWithException<Object[], E> consumer) {
        Object resources = this.open();
        ((Resources)resources).submit(r -> {
            Object[] arguments = new Object[classes.length];
            for (int i = 0; i < arguments.length; ++i) {
                arguments[i] = r.getInstance(classes[i]);
            }
            consumer.accept(arguments);
        });
        ((Resources)resources).commit();
    }

    default public <R, E extends Exception> void apply(Class[] classes, FunctionWithException<Object[], R, E> function) {
        this.commit(classes, function);
    }

    default public <R, E extends Exception> R commit(Class[] classes, FunctionWithException<Object[], R, E> function) {
        Resources resources = this.open();
        resources.submit(r -> {
            Object[] arguments = new Object[classes.length];
            for (int i = 0; i < arguments.length; ++i) {
                arguments[i] = r.getInstance(classes[i]);
            }
            return function.apply(arguments);
        });
        return resources.commit();
    }
}

