/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.e6tech.elements.common.resources.plugin.Plugin;
import net.e6tech.elements.common.resources.plugin.PluginFactory;
import net.e6tech.elements.common.resources.plugin.PluginManager;
import net.e6tech.elements.common.resources.plugin.PluginPath;
import net.e6tech.elements.common.util.SystemException;

public class PluginList<T extends Plugin>
implements PluginFactory {
    private List list = new ArrayList();
    private PluginPath<T> pluginPath;
    private PluginManager pluginManager;

    public PluginList<T> create(PluginManager pluginManager) {
        PluginList copy = null;
        try {
            copy = (PluginList)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        copy.pluginManager = pluginManager;
        copy.list = this.list;
        return copy;
    }

    @Override
    public void initialize(PluginPath path) {
        this.pluginPath = path;
    }

    public void add(Object object) {
        this.list.add(object);
    }

    public void add(T singleton) {
        this.list.add(singleton);
    }

    public void add(Class<? extends T> cls) {
        this.list.add(cls);
    }

    public void remove(Predicate predicate) {
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            if (!predicate.test(iterator.next())) continue;
            iterator.remove();
        }
    }

    public List plugins() {
        return this.list;
    }

    public List<T> list() {
        return this.pluginManager.getResources().configurator().computeIfAbsent(this.pluginPath.path(), key -> {
            ArrayList<T> l = new ArrayList<T>();
            for (Object obj : this.list) {
                l.add(this.pluginManager.createInstance(this.pluginPath, obj, new Object[0]));
            }
            return l;
        });
    }
}

