/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.util.concurrent;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class Wait<K, V> {
    Map<K, Entry<V>> table = new Hashtable<K, Entry<V>>();
    Thread thread;

    public void offer(K key, V value) {
        Entry<V> entry = this.table.get(key);
        if (entry != null) {
            entry.queue.offer(value);
        }
    }

    public void newEntry(K key, long expired) {
        this.newEntry(key, null, expired);
    }

    public void extendExpiration(K key, long time) {
        Entry<V> entry = this.table.get(key);
        if (entry != null) {
            entry.expired += time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newEntry(K key, Object userData, long expired) {
        Entry entry = new Entry();
        entry.userData = userData;
        entry.expired = expired;
        Map<K, Entry<V>> map = this.table;
        synchronized (map) {
            this.table.put(key, entry);
            this.table.notifyAll();
        }
        map = this.table;
        synchronized (map) {
            if (this.thread == null) {
                this.thread = new Thread(() -> {
                    LinkedList<K> list = new LinkedList<K>();
                    while (true) {
                        long waitTime = 0L;
                        list.clear();
                        Map<K, Entry<V>> map = this.table;
                        synchronized (map) {
                            for (K k : this.table.keySet()) {
                                Entry<V> e = this.table.get(k);
                                if (e == null) continue;
                                if (e.start + e.expired < System.currentTimeMillis()) {
                                    list.add(k);
                                    continue;
                                }
                                long exp = e.start + e.expired - System.currentTimeMillis();
                                if (exp <= 0L || waitTime != 0L && waitTime <= exp) continue;
                                waitTime = exp;
                            }
                        }
                        for (Object k : list) {
                            Entry<V> e = this.table.get(k);
                            if (e == null || e.start + e.expired >= System.currentTimeMillis()) continue;
                            this.table.remove(k);
                        }
                        if (waitTime > 0L) {
                            try {
                                Thread.sleep(waitTime);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        map = this.table;
                        synchronized (map) {
                            while (this.table.size() == 0) {
                                try {
                                    this.table.wait();
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                }
                            }
                        }
                    }
                });
                this.thread.setDaemon(true);
                this.thread.start();
            }
        }
    }

    public V remove(K key) {
        Entry<V> entry = this.table.get(key);
        if (entry == null) {
            return null;
        }
        this.table.remove(key);
        return (V)entry.queue.peek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V poll(K key, long timeout) {
        Entry<V> entry = this.table.get(key);
        if (entry == null) {
            return null;
        }
        try {
            Object v = entry.queue.poll(timeout, TimeUnit.MILLISECONDS);
            return v;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            V v = null;
            return v;
        }
        finally {
            this.remove(key);
        }
    }

    public V peek(K key) {
        Entry<V> entry = this.table.get(key);
        if (entry == null) {
            return null;
        }
        return (V)entry.queue.peek();
    }

    public <T> T peekUserData(K key) {
        Entry<V> entry = this.table.get(key);
        if (entry == null) {
            return null;
        }
        return (T)entry.userData;
    }

    private static class Entry<V> {
        long start = System.currentTimeMillis();
        long expired;
        BlockingQueue<V> queue = new LinkedBlockingQueue<V>(1);
        Object userData;

        private Entry() {
        }
    }
}

