/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.actor;

import com.google.common.io.ByteStreams;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import net.e6tech.elements.common.actor.typed.Guardian;
import net.e6tech.elements.common.actor.typed.worker.WorkerPoolConfig;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.Initializable;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.ResourceManager;
import net.e6tech.elements.common.resources.ResourceProvider;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.util.SystemException;

public class Genesis
implements Initializable {
    private static Logger logger = Logger.getLogger();
    public static final String WORKER_POOL_DISPATCHER = "worker-pool-dispatcher";
    private String name;
    private String configuration;
    private Guardian guardian;
    private WorkerPoolConfig workPoolConfig = new WorkerPoolConfig();
    private long timeout = 5000L;
    private String profile = "remote";
    private Config config;

    public Genesis() {
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public WorkerPoolConfig getWorkPoolConfig() {
        return this.workPoolConfig;
    }

    public void setWorkPoolConfig(WorkerPoolConfig workPoolConfig) {
        this.workPoolConfig = workPoolConfig;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public Config getConfig() {
        return this.config;
    }

    public Genesis(Provision provision, WorkerPoolConfig workerPoolConfig) {
        if (provision == null || provision.getBean(Guardian.class) == null) {
            WorkerPoolConfig wpc = workerPoolConfig;
            if (workerPoolConfig == null) {
                wpc = new WorkerPoolConfig();
            }
            this.setName(this.getClass().getSimpleName() + wpc.hashCode());
            this.setProfile("local");
            this.setWorkPoolConfig(wpc);
            this.initialize((Resources)null);
            if (provision != null) {
                provision.getResourceManager().addResourceProvider(ResourceProvider.wrap(this.getClass().getSimpleName(), this::shutdown));
            }
            this.getGuardian().setEmbedded(true);
        } else {
            this.guardian = provision.getBean(Guardian.class);
            this.setName(this.guardian.getName());
            if (workerPoolConfig != null) {
                this.setWorkPoolConfig(workerPoolConfig);
            }
        }
    }

    @Override
    public void initialize(Resources resources) {
        if (this.name == null) {
            throw new IllegalStateException("name is null");
        }
        Config conf = null;
        conf = this.configuration != null ? ConfigFactory.parseString((String)this.configuration) : ConfigFactory.defaultApplication();
        this.initialize(conf);
        if (resources != null) {
            ResourceManager resourceManager = resources.getResourceManager();
            resourceManager.addResourceProvider(ResourceProvider.wrap("Genesis", this::shutdown));
            if (this.guardian != null) {
                resourceManager.registerBean(this.guardian.getName(), this.guardian);
            }
        }
    }

    public void initialize(Config cfg) {
        if (this.name == null) {
            throw new IllegalStateException("name is null");
        }
        Config config = this.config = cfg != null ? cfg : ConfigFactory.defaultApplication();
        if (this.profile != null) {
            if (!this.profile.endsWith(".conf")) {
                this.profile = this.profile + ".conf";
            }
            String path = Genesis.class.getPackage().getName().replace('.', '/');
            try (InputStream in = Genesis.class.getClassLoader().getResourceAsStream(path + "/" + this.profile);){
                byte[] bytes = ByteStreams.toByteArray((InputStream)in);
                String classPathConfig = new String(bytes, StandardCharsets.UTF_8);
                this.config = this.config.withFallback((ConfigMergeable)ConfigFactory.parseString((String)classPathConfig));
            }
            catch (IOException e) {
                throw new SystemException(e);
            }
        }
        if (!this.config.hasPath(WORKER_POOL_DISPATCHER)) {
            this.config = this.config.withFallback((ConfigMergeable)ConfigFactory.parseString((String)"worker-pool-dispatcher {\n  type = Dispatcher\n  thread-pool-executor {\n      keep-alive-time = 60s\n      core-pool-size-min = 8\n      core-pool-size-factor = 5.0\n      # unbounded so that max-pool-size-factor has no effect.\n      task-queue-size = -1\n      allow-core-timeout = on\n    }\n  throughput = 1\n}"));
        }
        this.guardian = Guardian.create(this.getName(), this.getTimeout(), this.config, this.workPoolConfig);
    }

    public Guardian getGuardian() {
        return this.guardian;
    }

    public void shutdown() {
        this.guardian.getSystem().terminate();
        try {
            this.guardian.getSystem().getWhenTerminated().toCompletableFuture().get();
        }
        catch (Exception e) {
            logger.warn("Error during shutdown", e);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public void terminate() {
        if (this.guardian != null) {
            this.guardian.getSystem().terminate();
        }
    }

    public CompletionStage<Void> async(Runnable runnable) {
        return this.async(runnable, this.getTimeout());
    }

    public CompletionStage<Void> async(Runnable runnable, long timeout) {
        return this.guardian.talk(timeout).async(runnable);
    }

    public <R> CompletionStage<R> async(Callable<R> callable) {
        return this.async(callable, this.getTimeout());
    }

    public <R> CompletionStage<R> async(Callable<R> callable, long timeout) {
        return this.guardian.talk(timeout).async(callable);
    }
}

