/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.actor.concurrent;

import java.util.concurrent.Executor;
import net.e6tech.elements.common.actor.Genesis;
import net.e6tech.elements.common.actor.typed.Guardian;
import net.e6tech.elements.common.actor.typed.worker.WorkEvents;
import net.e6tech.elements.common.actor.typed.worker.WorkerPool;
import net.e6tech.elements.common.actor.typed.worker.WorkerPoolConfig;
import net.e6tech.elements.common.resources.Provision;

public class ActorExecutor
implements Executor {
    private WorkerPool workerPool;
    private boolean running;
    private Provision provision;
    private WorkerPoolConfig workerPoolConfig;

    public ActorExecutor(Provision provision, WorkerPoolConfig workerPoolConfig) {
        this.provision = provision;
        this.workerPoolConfig = workerPoolConfig;
        this.running = false;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized void start() {
        if (this.running) {
            return;
        }
        Guardian guardian = new Genesis(this.provision, this.workerPoolConfig).getGuardian();
        this.workerPool = !guardian.isEmbedded() ? (WorkerPool)guardian.childActor(WorkerPool.class).withProps(guardian.dispatcher(this.workerPoolConfig.getDispatcher())).spawnNow(new WorkerPool(this.workerPoolConfig)).virtualize() : guardian.getWorkerPool();
        this.running = true;
    }

    public synchronized void stop() {
        if (this.workerPool != null && this.running) {
            if (this.workerPool.getGuardian().isEmbedded()) {
                this.workerPool.getSystem().terminate();
            } else {
                this.workerPool.talk().stop();
            }
            this.running = false;
        }
    }

    public synchronized void join() {
        if (this.workerPool != null) {
            this.workerPool.join();
        }
    }

    public WorkEvents.StatusResponse status() {
        return this.workerPool.status(new WorkEvents.Status());
    }

    @Override
    public void execute(Runnable command) {
        this.workerPool.execute(new WorkEvents.RunnableTask(command));
    }
}

