/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.cache.ehcache;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.cache.Cache;
import net.e6tech.elements.common.cache.CacheConfiguration;
import net.e6tech.elements.common.cache.CacheProvider;
import org.ehcache.config.Builder;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.expiry.ExpiryPolicy;
import org.ehcache.jsr107.Eh107Configuration;
import org.ehcache.jsr107.EhcacheCachingProvider;

public class EhcacheProvider
implements CacheProvider {
    private static ExecutorService executorService = Executors.newSingleThreadExecutor(r -> new Thread(r, "EhcacheProviderCleaner"));

    @Override
    public String getProviderClassName() {
        return EhcacheCachingProvider.class.getName();
    }

    @Override
    public <K, V> Cache<K, V> createCache(CacheConfiguration cachePool, String poolName, Class<K> keyClass, Class<V> valueClass) {
        ResourcePoolsBuilder builder = cachePool.getMaxEntries() > 0L ? ResourcePoolsBuilder.heap((long)cachePool.getMaxEntries()) : ResourcePoolsBuilder.newResourcePoolsBuilder();
        ExpiryPolicy policy = ExpiryPolicyBuilder.timeToLiveExpiration((Duration)Duration.ofMillis(cachePool.getExpiry()));
        org.ehcache.config.CacheConfiguration cacheConfiguration = CacheConfigurationBuilder.newCacheConfigurationBuilder(keyClass, valueClass, (Builder)builder).withExpiry(policy).build();
        Cache cache = cachePool.getCacheManager().createCache(poolName, Eh107Configuration.fromEhcacheCacheConfiguration((org.ehcache.config.CacheConfiguration)cacheConfiguration));
        return (Cache)Proxy.newProxyInstance(Cache.class.getClassLoader(), new Class[]{Cache.class}, new CacheInvocationHandler(cache, cachePool));
    }

    private class CacheInvocationHandler<K, V>
    implements InvocationHandler {
        Cache<K, V> cache;
        long lastPut;
        long expiry;

        CacheInvocationHandler(Cache<K, V> cache, CacheConfiguration cachePool) {
            this.cache = cache;
            this.expiry = cachePool.getExpiry();
            this.lastPut = System.currentTimeMillis();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().startsWith("put") && System.currentTimeMillis() - this.lastPut > this.expiry) {
                executorService.submit(() -> this.cache.iterator().forEachRemaining(entry -> {}));
                this.lastPut = System.currentTimeMillis();
            }
            return method.invoke(this.cache, args);
        }
    }
}

