/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.inject.spi;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.e6tech.elements.common.inject.Injector;
import net.e6tech.elements.common.inject.Module;
import net.e6tech.elements.common.inject.ModuleFactory;
import net.e6tech.elements.common.inject.spi.Binding;
import net.e6tech.elements.common.inject.spi.InjectorImpl;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.reflection.Reflection;
import net.e6tech.elements.common.util.SystemException;

public class ModuleImpl
implements Module {
    private ModuleFactory factory;
    private final Map<Type, BindingMap> directory = new ConcurrentHashMap<Type, BindingMap>();
    private final Set<Binding> singletons = Collections.synchronizedSet(new HashSet());

    public ModuleImpl(ModuleFactory factory) {
        this.factory = factory;
    }

    public Binding getBinding(Type boundClass, String name) {
        BindingMap bindingMap = this.directory.get(boundClass);
        if (bindingMap == null) {
            return null;
        }
        return bindingMap.get(name);
    }

    @Override
    public ModuleFactory getFactory() {
        return this.factory;
    }

    @Override
    public synchronized void add(Module module) {
        ModuleImpl moduleImpl = (ModuleImpl)module;
        ConcurrentHashMap<Type, BindingMap> dir = new ConcurrentHashMap<Type, BindingMap>(moduleImpl.directory);
        for (Map.Entry<Type, BindingMap> entry : dir.entrySet()) {
            BindingMap existing = this.directory.get(entry.getKey());
            if (existing != null) {
                existing.merge(entry.getValue());
                continue;
            }
            this.directory.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void bindClass(Class cls, Class implementation) {
        Type[] types;
        for (Type type : types = this.getBindTypes(cls)) {
            BindingMap bindList = this.directory.computeIfAbsent(type, t -> new BindingMap());
            bindList.bind(null, new Binding(implementation));
        }
    }

    @Override
    public Class getBoundClass(Class cls) {
        BindingMap bindList = this.directory.get(cls);
        return bindList == null ? null : bindList.get(null).getImplementation();
    }

    @Override
    public Object bindInstance(Class cls, Object inst) {
        return this.bindInstance(cls, inst, false);
    }

    @Override
    public Object rebindInstance(Class cls, Object inst) {
        return this.bindInstance(cls, inst, true);
    }

    private Object bindInstance(Class cls, Object inst, boolean rebind) {
        Object instance = this.newInstance(inst);
        Type[] types = this.getBindTypes(cls);
        Binding binding = new Binding(instance);
        for (Type type : types) {
            if (this.directory.containsKey(type) && !rebind) continue;
            BindingMap bindingMap = this.directory.computeIfAbsent(type, t -> new BindingMap());
            bindingMap.bind(null, binding);
        }
        this.singletons.add(binding);
        this.bindProperties(cls, null, inst, rebind);
        return instance;
    }

    private void bindProperties(Class cls, String name, Object inst, boolean rebind) {
        for (String propName : this.getBindProperties(cls)) {
            PropertyDescriptor desc = Reflection.getPropertyDescriptor(cls, propName);
            Object propertyValue = this.getProperty(cls, propName, inst);
            if (propertyValue == null) continue;
            Class<?> propType = desc.getPropertyType();
            Type[] propTypes = this.getBindTypes(propType);
            Binding binding = new Binding(propertyValue);
            for (Type type : propTypes) {
                if (this.directory.containsKey(type) && this.directory.get(type).get(name) != null && !rebind) continue;
                BindingMap bindingMap = this.directory.computeIfAbsent(type, t -> new BindingMap());
                bindingMap.bind(name, binding);
            }
            this.singletons.add(binding);
        }
    }

    private Object getProperty(Class cls, String propName, Object inst) {
        PropertyDescriptor desc = Reflection.getPropertyDescriptor(cls, propName);
        Object propertyValue = null;
        if (desc != null && desc.getReadMethod() != null) {
            try {
                propertyValue = desc.getReadMethod().invoke(inst, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                Logger.suppress(e);
            }
        }
        return propertyValue;
    }

    @Override
    public Object bindNamedInstance(Class cls, String name, Object inst) {
        return this.bindNamedInstance(cls, name, inst, false);
    }

    @Override
    public Object rebindNamedInstance(Class cls, String name, Object inst) {
        return this.bindNamedInstance(cls, name, inst, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object bindNamedInstance(Class cls, String name, Object inst, boolean rebind) {
        Object instance = this.newInstance(inst);
        Type[] types = this.getBindTypes(cls);
        Binding binding = new Binding(instance);
        Map<Type, BindingMap> map = this.directory;
        synchronized (map) {
            for (Type type : types) {
                BindingMap bindMap = this.directory.computeIfAbsent(type, t -> new BindingMap());
                if (bindMap.get(name) != null && !rebind) continue;
                bindMap.bind(name, binding);
            }
            this.singletons.add(binding);
            this.bindProperties(cls, name, inst, rebind);
        }
        return instance;
    }

    @Override
    public Object unbindInstance(Class cls) {
        return this.unbindNamedInstance(cls, null);
    }

    @Override
    public Object unbindNamedInstance(Class cls, String name) {
        Type[] types = this.getBindTypes(cls);
        Object ret = null;
        for (Type type : types) {
            BindingMap bindList = this.directory.get(type);
            if (bindList == null) continue;
            Object value = null;
            Binding binding = bindList.unbind(name);
            if (binding == null) continue;
            this.singletons.remove(binding);
            value = binding.getValue();
            if (bindList.size() == 0) {
                this.directory.remove(type);
            }
            if (value == null) continue;
            ret = value;
            this.unbindProperties(cls, name, value);
        }
        return ret;
    }

    private void unbindProperties(Class cls, String name, Object inst) {
        for (String propName : this.getBindProperties(cls)) {
            Type[] propTypes;
            PropertyDescriptor desc = Reflection.getPropertyDescriptor(cls, propName);
            Object propertyValue = this.getProperty(cls, propName, inst);
            if (propertyValue == null) continue;
            for (Type type : propTypes = this.getBindTypes(desc.getPropertyType())) {
                BindingMap bindingMap = this.directory.get(type);
                if (bindingMap == null) continue;
                Binding binding = bindingMap.unbind(name);
                if (binding != null) {
                    this.singletons.remove(binding);
                }
                if (bindingMap.size() != 0) continue;
                this.directory.remove(type);
            }
        }
    }

    private Object newInstance(Object instance) {
        if (instance instanceof Class) {
            try {
                return ((Class)instance).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
        }
        return instance;
    }

    @Override
    public <T> T getBoundNamedInstance(Class<T> cls, String name) {
        BindingMap bindList = this.directory.get(cls);
        if (bindList == null) {
            return null;
        }
        Binding binding = bindList.get(name);
        if (binding == null) {
            return null;
        }
        return (T)binding.getValue();
    }

    @Override
    public <T> T getBoundInstance(Class<T> cls) {
        return this.getBoundNamedInstance(cls, null);
    }

    public boolean hasInstance(Class cls) {
        return this.directory.containsKey(cls);
    }

    public boolean hasBinding(Class cls) {
        return this.directory.containsKey(cls);
    }

    @Override
    public Map<String, Object> listBindings(Class cls) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BindingMap bindingMap = this.directory.get(cls);
        if (bindingMap != null) {
            for (Map.Entry entry : bindingMap.bindings.entrySet()) {
                if (((Binding)entry.getValue()).getImplementation() != null) {
                    map.put((String)entry.getKey(), ((Binding)entry.getValue()).getImplementation());
                    continue;
                }
                map.put((String)entry.getKey(), ((Binding)entry.getValue()).getValue());
            }
        }
        return map;
    }

    @Override
    public Map<Type, Map<String, Object>> listBindings() {
        HashMap<Type, Map<String, Object>> bindings = new HashMap<Type, Map<String, Object>>();
        for (Map.Entry<Type, BindingMap> entry : this.directory.entrySet()) {
            HashMap map = new HashMap();
            BindingMap bindingMap = entry.getValue();
            for (Map.Entry e : bindingMap.bindings.entrySet()) {
                if (((Binding)e.getValue()).getImplementation() != null) {
                    map.put(e.getKey(), ((Binding)e.getValue()).getImplementation());
                    continue;
                }
                map.put(e.getKey(), ((Binding)e.getValue()).getValue());
            }
            bindings.put(entry.getKey(), map);
        }
        return bindings;
    }

    @Override
    public Injector build(Module ... components) {
        return this.build(true, components);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Injector build(boolean strict, Module ... components) {
        Injector parent = null;
        if (components != null && components.length > 0) {
            Module[] remaining = new Module[components.length - 1];
            if (remaining.length > 0) {
                System.arraycopy(components, 1, remaining, 0, components.length - 1);
            }
            parent = components[0].build(strict, remaining);
        }
        InjectorImpl injector = new InjectorImpl(this, (InjectorImpl)parent);
        ArrayList<Binding> list = null;
        Set<Binding> set = this.singletons;
        synchronized (set) {
            if (!this.singletons.isEmpty()) {
                list = new ArrayList<Binding>(this.singletons);
                this.singletons.clear();
            }
        }
        if (list != null) {
            for (Binding binding : list) {
                injector.inject(binding.getValue(), strict);
            }
        }
        return injector;
    }

    private static class BindingMap {
        private static final String NULL_KEY = "";
        private Map<String, Binding> bindings = new ConcurrentHashMap<String, Binding>();

        private BindingMap() {
        }

        Binding get(String name) {
            return this.bindings.get(name == null ? NULL_KEY : name);
        }

        void bind(String name, Binding binding) {
            this.bindings.put(name == null ? NULL_KEY : name, binding);
        }

        Binding unbind(String name) {
            return this.bindings.remove(name == null ? NULL_KEY : name);
        }

        int size() {
            return this.bindings.size();
        }

        void merge(BindingMap bindingMap) {
            ConcurrentHashMap<String, Binding> copy = new ConcurrentHashMap<String, Binding>(bindingMap.bindings);
            for (Map.Entry entry : copy.entrySet()) {
                if (this.bindings.containsKey(entry.getKey())) continue;
                this.bindings.put((String)entry.getKey(), (Binding)copy.get(entry.getKey()));
            }
        }
    }
}

