/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.reflection;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.e6tech.elements.common.util.SystemException;

public class PackageScanner {
    private int concurrencyLevel = 32;
    private int maximumSize = 100;
    private int initialCapacity = 16;
    private Cache<ClassLoader, Cache<String, Class[]>> topLevelRecursive;
    private Cache<ClassLoader, Cache<String, Class[]>> topLevel;
    private Cache<ClassLoader, ClassPath> classPathCache;

    public PackageScanner() {
        this.reset();
    }

    public int getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    public void setConcurrencyLevel(int concurrencyLevel) {
        this.concurrencyLevel = concurrencyLevel;
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(int maximumSize) {
        this.maximumSize = maximumSize;
    }

    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    public void setInitialCapacity(int initialCapacity) {
        this.initialCapacity = initialCapacity;
    }

    public void reset() {
        this.topLevelRecursive = CacheBuilder.newBuilder().concurrencyLevel(this.concurrencyLevel).initialCapacity(this.initialCapacity).maximumSize((long)this.maximumSize).expireAfterWrite(0x6DDD00L, TimeUnit.MILLISECONDS).build();
        this.topLevel = CacheBuilder.newBuilder().concurrencyLevel(this.concurrencyLevel).initialCapacity(this.initialCapacity).maximumSize((long)this.maximumSize).expireAfterWrite(0x6DDD00L, TimeUnit.MILLISECONDS).build();
        this.classPathCache = CacheBuilder.newBuilder().concurrencyLevel(this.concurrencyLevel).initialCapacity(this.initialCapacity).maximumSize((long)this.maximumSize).expireAfterWrite(0x6DDD00L, TimeUnit.MILLISECONDS).build();
    }

    public Class[] getTopLevelClassesRecursive(ClassLoader classLoader, String packageName) {
        try {
            ClassPath classPath = (ClassPath)this.classPathCache.get((Object)classLoader, () -> ClassPath.from((ClassLoader)classLoader));
            Cache cache = (Cache)this.topLevelRecursive.get((Object)classLoader, () -> CacheBuilder.newBuilder().concurrencyLevel(this.concurrencyLevel).initialCapacity(this.initialCapacity).maximumSize((long)this.maximumSize).build());
            return (Class[])cache.get((Object)packageName, () -> PackageScanner.toClasses((ImmutableSet<ClassPath.ClassInfo>)classPath.getTopLevelClassesRecursive(packageName)));
        }
        catch (ExecutionException e) {
            throw new SystemException(e.getCause());
        }
    }

    public Class[] getTopLevelClasses(ClassLoader classLoader, String packageName) {
        try {
            ClassPath classPath = (ClassPath)this.classPathCache.get((Object)classLoader, () -> ClassPath.from((ClassLoader)classLoader));
            Cache cache = (Cache)this.topLevel.get((Object)classLoader, () -> CacheBuilder.newBuilder().concurrencyLevel(this.concurrencyLevel).initialCapacity(this.initialCapacity).maximumSize((long)this.maximumSize).expireAfterWrite(0x6DDD00L, TimeUnit.MILLISECONDS).build());
            return (Class[])cache.get((Object)packageName, () -> PackageScanner.toClasses((ImmutableSet<ClassPath.ClassInfo>)classPath.getTopLevelClasses(packageName)));
        }
        catch (ExecutionException e) {
            throw new SystemException(e.getCause());
        }
    }

    private static Class[] toClasses(ImmutableSet<ClassPath.ClassInfo> set) {
        ArrayList<Class> classes = new ArrayList<Class>();
        for (ClassPath.ClassInfo info : set) {
            classes.add(info.load());
        }
        return classes.toArray(new Class[0]);
    }
}

