/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.e6tech.elements.common.resources.plugin.PluginPath;

public class PluginPaths<T> {
    private List<PluginPath> paths = new ArrayList<PluginPath>();
    private Class<T> type;
    private String toString;
    private int hash = 0;

    public static <T> PluginPaths<T> of(PluginPath<T> path) {
        PluginPaths<T> paths = new PluginPaths<T>();
        paths.add(path);
        return paths;
    }

    public static <T> PluginPaths<T> of(Class baseClass, Class<T> cls) {
        PluginPaths<T> paths = new PluginPaths<T>();
        paths.add(PluginPath.of(baseClass).and(cls));
        return paths;
    }

    public static <T> PluginPaths<T> of(Class baseClass, String baseName, Class<T> cls) {
        PluginPaths<T> paths = new PluginPaths<T>();
        paths.add(PluginPath.of(baseClass, baseName).and(cls));
        return paths;
    }

    public PluginPaths<T> add(Class baseClass, Class<T> cls) {
        return this.add(PluginPath.of(baseClass).and(cls));
    }

    public PluginPaths<T> add(Class baseClass, String baseName, Class<T> cls) {
        return this.add(PluginPath.of(baseClass, baseName).and(cls));
    }

    public PluginPaths<T> add(PluginPath<T> ... paths) {
        if (paths != null && paths.length > 0) {
            for (PluginPath<T> path : paths) {
                this.paths.add(path);
                this.type = path.getType();
            }
            this.toString = null;
            this.hash = 0;
        }
        return this;
    }

    public PluginPaths<T> add(List<PluginPath<T>> paths) {
        this.paths.addAll(paths);
        if (!paths.isEmpty()) {
            this.type = paths.get(paths.size() - 1).getType();
            this.toString = null;
            this.hash = 0;
        }
        return this;
    }

    public List<PluginPath> getPaths() {
        return this.paths;
    }

    public Class<T> getType() {
        return this.type;
    }

    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (PluginPath path : this.paths) {
            if (first) {
                builder.append(path);
                first = false;
                continue;
            }
            builder.append(":");
            builder.append(path);
        }
        this.toString = this.paths.toString();
        return this.toString;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Objects.hash(this.paths.toArray());
        }
        return this.hash;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PluginPaths)) {
            return false;
        }
        PluginPaths pp = (PluginPaths)object;
        if (this.paths.size() == pp.getPaths().size()) {
            for (int i = 0; i < this.paths.size(); ++i) {
                if (Objects.equals(this.paths.get(i), pp.paths.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

