/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.script;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import javax.script.ScriptException;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.script.AbstractScriptShell;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.common.util.function.SupplierWithException;

public abstract class AbstractScriptBase<T extends AbstractScriptShell>
extends Script {
    public static final String CALLER = "__caller";
    private static final Logger logger = Logger.getLogger();
    T scriptShell;
    private Binding privateBinding = new Binding();

    public void setBinding(Binding binding) {
        if (binding != null) {
            if (binding.hasVariable("__dir")) {
                this.privateBinding.setVariable("__dir", binding.getProperty("__dir"));
            }
            if (binding.hasVariable("__file")) {
                this.privateBinding.setVariable("__file", binding.getProperty("__file"));
            }
        }
        super.setBinding(binding);
    }

    public Object getProperty(String property) {
        try {
            return this.privateBinding.getVariable(property);
        }
        catch (MissingPropertyException e) {
            return super.getProperty(property);
        }
    }

    public T getShell() {
        if (this.scriptShell == null) {
            this.scriptShell = (AbstractScriptShell)this.getVariable("shell");
        }
        return this.scriptShell;
    }

    protected boolean hasVariable(String var) {
        return this.getBinding().hasVariable(var);
    }

    protected <V> V getVariable(String var) {
        return (V)this.getBinding().getVariable(var);
    }

    protected void setVariable(String var, Object val) {
        this.getBinding().setVariable(var, val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T, E extends Exception> T call(SupplierWithException<T, E> supplier) throws E {
        Object prev = ((AbstractScriptShell)this.getShell()).getScripting().get(CALLER);
        try {
            ((AbstractScriptShell)this.getShell()).getScripting().put(CALLER, (Object)this);
            T t = supplier.get();
            return t;
        }
        finally {
            ((AbstractScriptShell)this.getShell()).getScripting().put(CALLER, prev);
        }
    }

    public Object execDir(String path) throws ScriptException {
        String dir = (String)this.getProperty("__dir");
        Path p = Paths.get(dir, path);
        return this.call(() -> ((AbstractScriptShell)this.getShell()).getScripting().exec(p.toString()));
    }

    public Object exec(String path) throws ScriptException {
        return this.call(() -> ((AbstractScriptShell)this.getShell()).getScripting().exec(path));
    }

    public void exec(Object ... items) {
        this.call(() -> {
            ((AbstractScriptShell)this.getShell()).exec(items);
            return null;
        });
    }

    public AbstractScriptShell.Dir dir(String dir) {
        return ((AbstractScriptShell)this.getShell()).dir(dir);
    }

    public Object tryExec(String path) {
        try {
            return this.call(() -> ((AbstractScriptShell)this.getShell()).getScripting().exec(path));
        }
        catch (ScriptException e) {
            if (e.getCause() instanceof IOException) {
                logger.info("Script {} not processed: {}", path, e.getCause().getMessage());
            } else {
                logger.warn("Script not processed due to error.", e);
            }
            return null;
        }
    }

    public void after(Object callable) {
        ((AbstractScriptShell)this.scriptShell).runAfter(callable);
    }

    public void setup(Object caller, Object callable) {
        ((AbstractScriptShell)this.scriptShell).runNow(caller, callable);
    }

    public void systemProperties(Closure closure) {
        closure.setResolveStrategy(1);
        closure.setDelegate((Object)new GroovyObjectSupport(){

            public Object invokeMethod(String name, Object args) {
                String val;
                Properties props = System.getProperties();
                Object[] arr = (Object[])args;
                if ("set".equals(name)) {
                    if (arr.length != 2) {
                        return super.invokeMethod(name, args);
                    }
                    if ((arr[0] instanceof String || arr[0] instanceof GString) && (arr[1] instanceof String || arr[1] instanceof GString)) {
                        String key = arr[0] == null ? null : arr[0].toString();
                        String value = arr[1] == null ? null : arr[1].toString();
                        return props.setProperty(key, value);
                    }
                    return super.invokeMethod(name, args);
                }
                String string = val = arr[0] == null ? null : arr[0].toString();
                if (val != null && !props.containsKey(name)) {
                    return props.put(name, val);
                }
                return props.get(name);
            }
        });
        closure.call();
    }

    public void env(String name, Closure closure) {
        if (((AbstractScriptShell)this.getShell()).getScripting().get("env").equals(name)) {
            closure.call();
        }
    }

    public String getenv(String envName, String defaultVal) {
        String value = System.getenv(envName);
        return value != null ? value : defaultVal;
    }

    public Class loadClass(String className) {
        return this.loadClass(this.getShell().getClass().getClassLoader(), className);
    }

    public Class loadClass(ClassLoader classLoader, String className) {
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new SystemException(e);
        }
    }
}

