/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.util.concurrent;

import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.WorkHandler;
import com.lmax.disruptor.YieldingWaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import com.lmax.disruptor.util.DaemonThreadFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.common.util.concurrent.DisruptorConfig;

public class DisruptorPool {
    private DisruptorConfig config = new DisruptorConfig();
    Disruptor<Event> disruptor;

    public DisruptorPool() {
        this.start();
    }

    public DisruptorConfig getConfig() {
        return this.config;
    }

    public void setConfig(DisruptorConfig config) {
        this.config = config;
    }

    public Disruptor<Event> getDisruptor() {
        return this.disruptor;
    }

    public void setDisruptor(Disruptor<Event> disruptor) {
        this.disruptor = disruptor;
    }

    public void start() {
        this.disruptor = new Disruptor(() -> new Event(), this.config.getBufferSize(), (ThreadFactory)DaemonThreadFactory.INSTANCE, ProducerType.SINGLE, (WaitStrategy)new YieldingWaitStrategy());
        WorkHandler handler = Event::handle;
        WorkHandler[] workers = new WorkHandler[this.config.getHandlerSize()];
        for (int i = 0; i < workers.length; ++i) {
            workers[i] = handler;
        }
        this.disruptor.handleEventsWithWorkerPool(workers).then(new EventHandler[]{(event, sequence, endOfBatch) -> event.clear()});
        this.disruptor.start();
    }

    public RunnableWait run(Runnable runnable) {
        return this.run(runnable, null);
    }

    public RunnableWait run(Runnable runnable, Consumer<Exception> exceptionHandler) {
        Result<Void> result = new Result<Void>();
        RingBuffer ringBuffer = this.disruptor.getRingBuffer();
        ringBuffer.publishEvent((event, sequence, buffer) -> {
            ((Event)event).runnable = runnable;
            ((Event)event).result = result;
            ((Event)event).exceptionHandler = exceptionHandler;
        }, new Object[0]);
        return new RunnableWait(result);
    }

    public void runAsync(Runnable runnable) {
        this.runAsync(runnable, null);
    }

    public void runAsync(Runnable runnable, Consumer<Exception> exceptionHandler) {
        RingBuffer ringBuffer = this.disruptor.getRingBuffer();
        ringBuffer.publishEvent((event, sequence, buffer) -> {
            ((Event)event).runnable = runnable;
            ((Event)event).exceptionHandler = exceptionHandler;
        }, new Object[0]);
    }

    public <V> CallableWait<V> call(Callable<V> callable) {
        return this.call(callable, null);
    }

    public <V> CallableWait<V> call(Callable<V> callable, Consumer<Exception> exceptionHandler) {
        Result result = new Result();
        RingBuffer ringBuffer = this.disruptor.getRingBuffer();
        ringBuffer.publishEvent((event, sequence, buffer) -> {
            ((Event)event).callable = callable;
            ((Event)event).result = result;
            ((Event)event).exceptionHandler = exceptionHandler;
        }, new Object[0]);
        return new CallableWait(result);
    }

    private static class Event<V> {
        private Result result;
        private Runnable runnable;
        private Callable<V> callable;
        private Consumer<Exception> exceptionHandler;

        private Event() {
        }

        void clear() {
            this.result = null;
            this.runnable = null;
            this.callable = null;
            this.exceptionHandler = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handle() {
            if (this.runnable != null) {
                this.run();
            } else {
                this.call();
            }
            if (this.result != null) {
                Result result = this.result;
                synchronized (result) {
                    this.result.notifyAll();
                    this.result.done = true;
                }
            }
        }

        void run() {
            block3: {
                try {
                    this.runnable.run();
                }
                catch (Exception ex) {
                    if (this.exceptionHandler != null) {
                        this.exceptionHandler.accept(ex);
                    }
                    if (this.result == null) break block3;
                    this.result.exception = ex;
                }
            }
        }

        void call() {
            block4: {
                try {
                    V ret = this.callable.call();
                    if (this.result != null) {
                        this.result.returnValue = ret;
                    }
                }
                catch (Exception ex) {
                    if (this.exceptionHandler != null) {
                        this.exceptionHandler.accept(ex);
                    }
                    if (this.result == null) break block4;
                    this.result.exception = ex;
                }
            }
        }
    }

    private static class Result<V> {
        private Exception exception;
        private V returnValue;
        private volatile boolean done = false;

        private Result() {
        }
    }

    public static class CallableWait<V>
    extends Wait<V> {
        CallableWait(Result<V> result) {
            super(result);
        }

        public V complete(long timeout) throws TimeoutException {
            this.await(timeout);
            return (V)this.result.returnValue;
        }
    }

    public static class RunnableWait
    extends Wait<Void> {
        RunnableWait(Result<Void> result) {
            super(result);
        }

        public void complete(long timeout) throws TimeoutException {
            this.await(timeout);
        }
    }

    public static class Wait<V> {
        Result<V> result;

        Wait(Result<V> result) {
            this.result = result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void await(long timeout) throws TimeoutException {
            long start = System.currentTimeMillis();
            boolean first = true;
            Result<V> result = this.result;
            synchronized (result) {
                while (!((Result)this.result).done) {
                    if (!first && System.currentTimeMillis() - start > timeout) {
                        throw new TimeoutException();
                    }
                    if (first) {
                        first = false;
                    }
                    try {
                        long wait = timeout - (System.currentTimeMillis() - start);
                        if (wait > 0L) {
                            this.result.wait(wait);
                        }
                        if (((Result)this.result).exception == null) continue;
                        throw new SystemException(((Result)this.result).exception);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new SystemException(e);
                    }
                }
            }
        }
    }
}

