/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster.catalyst;

import java.io.Serializable;
import java.util.Collection;
import net.e6tech.elements.network.cluster.catalyst.Reactor;
import net.e6tech.elements.network.cluster.catalyst.Scalar;

public class Reduce<Re extends Reactor, T, R>
extends Scalar<Re, T, R> {
    private static final long serialVersionUID = 2541978434272522759L;
    private transient ReduceOp<R> reduceOp;

    public Reduce() {
    }

    public Reduce(ReduceOp<R> reduce) {
        this.setMapping((reactor, collection) -> reduce.reduce((Collection)collection));
    }

    @FunctionalInterface
    public static interface ReduceOp<T>
    extends Serializable {
        default public T reduce(Collection<T> collection) {
            Object accumulator = null;
            boolean first = true;
            for (T r : collection) {
                if (r == null) continue;
                if (first) {
                    first = false;
                    accumulator = r;
                    continue;
                }
                accumulator = this.reduce(accumulator, r);
            }
            return accumulator;
        }

        public T reduce(T var1, T var2);
    }
}

