/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.restful;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.NotAllowedException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.core.Response;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.util.ErrorResponse;
import net.e6tech.elements.common.util.ExceptionMapper;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.network.restful.JsonMarshaller;
import net.e6tech.elements.network.restful.Marshaller;
import net.e6tech.elements.network.restful.Param;
import net.e6tech.elements.network.restful.Request;
import net.e6tech.elements.network.restful.Response;
import net.e6tech.elements.security.JavaKeyStore;

public class RestfulClient {
    private static Logger logger = Logger.getLogger();
    private static final X509Certificate[] EMPTY_CERTIFICATES = new X509Certificate[0];
    private ExceptionMapper exceptionMapper;
    private String staticAddress;
    private String encoding = StandardCharsets.UTF_8.name();
    private String trustStore;
    private String trustStoreFormat = "PKCS12";
    private boolean skipHostnameCheck = false;
    private boolean skipCertCheck = false;
    private SSLSocketFactory sslSocketFactory;
    private int connectionTimeout = -1;
    private int readTimeout = -1;
    private PrintWriter printer;
    private boolean printRawResponse = false;
    private String proxyHost;
    private int proxyPort = -1;
    private Marshaller marshaller = new JsonMarshaller();

    public RestfulClient() {
    }

    public RestfulClient(String address) {
        this.setAddress(address);
    }

    public ExceptionMapper getExceptionMapper() {
        return this.exceptionMapper;
    }

    public void setExceptionMapper(ExceptionMapper exceptionMapper) {
        this.exceptionMapper = exceptionMapper;
    }

    public synchronized String getAddress() {
        return this.staticAddress;
    }

    public synchronized void setAddress(String path) {
        this.staticAddress = path;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(String trustStore) {
        this.sslSocketFactory = null;
        this.trustStore = trustStore;
    }

    public String getTrustStoreFormat() {
        return this.trustStoreFormat;
    }

    public void setTrustStoreFormat(String trustStoreFormat) {
        this.trustStoreFormat = trustStoreFormat;
    }

    public boolean isSkipHostnameCheck() {
        return this.skipHostnameCheck;
    }

    public void setSkipHostnameCheck(boolean skipHostnameCheck) {
        this.sslSocketFactory = null;
        this.skipHostnameCheck = skipHostnameCheck;
    }

    public boolean isSkipCertCheck() {
        return this.skipCertCheck;
    }

    public void setSkipCertCheck(boolean skipCertCheck) {
        this.sslSocketFactory = null;
        this.skipCertCheck = skipCertCheck;
    }

    public PrintWriter getPrinter() {
        return this.printer;
    }

    @Inject(optional=true)
    public void setPrinter(PrintWriter printer) {
        this.printer = printer;
    }

    public boolean isPrintRawResponse() {
        return this.printRawResponse;
    }

    public void setPrintRawResponse(boolean printRawResponse) {
        this.printRawResponse = printRawResponse;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    private Param[] toParams(Object object) {
        ArrayList<Param> params = new ArrayList<Param>();
        if (object != null) {
            Class<?> cls = object.getClass();
            BeanInfo beanInfo = null;
            try {
                beanInfo = Introspector.getBeanInfo(cls);
            }
            catch (IntrospectionException e) {
                throw new SystemException((Throwable)e);
            }
            for (PropertyDescriptor desc : beanInfo.getPropertyDescriptors()) {
                if (desc.getReadMethod() == null) continue;
                try {
                    Object value = desc.getReadMethod().invoke(object, new Object[0]);
                    if (value == null) continue;
                    params.add(new Param(desc.getName(), value.toString()));
                }
                catch (Exception e) {
                    throw new SystemException((Throwable)e);
                }
            }
        }
        return params.toArray(new Param[params.size()]);
    }

    public Response get(String context, Object object) throws Throwable {
        if (object instanceof Param) {
            return this.get(context, (Param)object);
        }
        return this.get(context, this.toParams(object));
    }

    public Request create() {
        return new Request(this);
    }

    public Response get(String context, Param ... params) throws Throwable {
        return new Request(this).get(context, params);
    }

    public Response delete(String context, Param ... params) throws Throwable {
        return new Request(this).delete(context, params);
    }

    public Response put(String context, Object data, Object object) throws Throwable {
        if (object instanceof Param) {
            return this.put(context, data, (Param)object);
        }
        return this.put(context, data, this.toParams(object));
    }

    public Response put(String context, Object data, Param ... params) throws Throwable {
        return new Request(this).put(context, data, params);
    }

    public Response post(String context, Object data, Object object) throws Throwable {
        if (object instanceof Param) {
            return this.post(context, data, (Param)object);
        }
        return this.post(context, data, this.toParams(object));
    }

    public Response post(String context, Object data, Param ... params) throws Throwable {
        return new Request(this).post(context, data, params);
    }

    private String constructPath(String destination, String ctx, Param ... params) {
        String dest = destination;
        String context = ctx;
        String fullPath = null;
        if (!dest.endsWith("/")) {
            dest = dest + "/";
        }
        if (context != null) {
            while (context.startsWith("/")) {
                context = context.substring(1);
            }
        }
        fullPath = dest + context;
        while (fullPath.endsWith("/")) {
            fullPath = fullPath.substring(0, fullPath.length() - 1);
        }
        if (params != null) {
            StringBuilder builder = new StringBuilder();
            ArrayList<Param> list = new ArrayList<Param>();
            for (Param param : params) {
                if (param.getValue() == null) continue;
                list.add(param);
            }
            for (int i = 0; i < list.size(); ++i) {
                if (i == 0) {
                    builder.append("?");
                }
                builder.append(((Param)list.get(i)).encode());
                if (i == list.size() - 1) continue;
                builder.append("&");
            }
            fullPath = fullPath + builder.toString();
        }
        return fullPath;
    }

    HttpURLConnection open(String dest, String context, Param ... params) throws IOException {
        String fullPath = this.constructPath(dest, context, params);
        URL url = null;
        try {
            logger.debug(fullPath);
            url = new URL(fullPath);
            HttpURLConnection conn = null;
            if (this.proxyHost != null && this.proxyPort > 0) {
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, this.proxyPort));
                conn = (HttpURLConnection)url.openConnection(proxy);
            } else {
                conn = (HttpURLConnection)url.openConnection();
            }
            if (this.connectionTimeout >= 0) {
                conn.setConnectTimeout(this.connectionTimeout);
            }
            if (this.readTimeout >= 0) {
                conn.setReadTimeout(this.readTimeout);
            }
            if (conn instanceof HttpsURLConnection) {
                HttpsURLConnection https = (HttpsURLConnection)conn;
                https.setSSLSocketFactory(this.getSSLSocketFactory());
                if (this.skipHostnameCheck || this.skipCertCheck) {
                    https.setHostnameVerifier((hostname, session) -> true);
                }
            }
            return conn;
        }
        catch (MalformedURLException e) {
            throw logger.systemException((Throwable)e);
        }
    }

    protected Response submit(String context, String method, Properties requestProperties, Object data, Param ... params) throws Throwable {
        return this._submit(this.staticAddress, context, method, requestProperties, data, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response _submit(String dest, String context, String method, Properties requestProperties, Object data, Param ... params) throws Throwable {
        Response response = null;
        HttpURLConnection conn = null;
        try {
            conn = this.open(dest, context, params);
            if (method.equals("POST") || method.equals("PUT")) {
                conn.setDoOutput(true);
                conn.setRequestProperty("Content-Type", this.marshaller.getContentType());
            }
            conn.setRequestMethod(method);
            this.setConnectionProperties(conn);
            this.loadRequestProperties(conn, requestProperties);
            if (this.printer != null) {
                this.printer.println("REQUEST ----------------------------");
                this.printer.println(method + " " + this.constructPath(dest, context, params));
                this.printHeaders(requestProperties);
                this.printHeaders(conn.getRequestProperties());
                if (data != null) {
                    this.printer.println(this.marshaller.prettyPrintRequest(data));
                }
                this.printer.println();
            }
            if (method.equals("POST") || method.equals("PUT")) {
                OutputStream out = conn.getOutputStream();
                if (data != null) {
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(out), StandardCharsets.UTF_8);
                    String posted = this.marshaller.encodeRequest(data);
                    writer.write(posted);
                    logger.debug(posted);
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                }
                out.close();
            }
            response = this.readResponse(conn);
            if (this.printer != null) {
                this.printer.println("RESPONSE ----------------------------");
                List<String> statusList = response.getHeaderFields().get(null);
                if (statusList != null && !statusList.isEmpty()) {
                    this.printer.println(statusList.get(0));
                }
                this.printer.println("Response Code=" + response.getResponseCode());
                this.printHeaders(response.getHeaderFields());
                String result = response.getResult();
                if (result != null && result.length() > 0) {
                    if (this.isPrintRawResponse()) {
                        this.printer.println("===== RAW RESPONSE: START =====");
                        this.printer.println(result);
                        this.printer.println("===== RAW RESPONSE: END =======");
                    }
                    this.printer.println(this.marshaller.prettyPrintResponse(result));
                }
                this.printer.println();
            }
            try {
                this.checkResponseCode(response.getResponseCode(), response.getResult());
            }
            catch (ClientErrorException ex) {
                Throwable mappedThrowable = null;
                String result = ex.getMessage();
                if (result != null && this.exceptionMapper != null) {
                    try {
                        ErrorResponse error = this.marshaller.readErrorResponse(result);
                        if (error != null) {
                            mappedThrowable = this.exceptionMapper.fromResponse((Object)error);
                        }
                    }
                    catch (Exception e) {
                        Logger.suppress((Throwable)e);
                    }
                }
                if (mappedThrowable != null) {
                    throw mappedThrowable;
                }
                throw ex;
            }
        }
        catch (MalformedURLException e) {
            logger.systemException((Throwable)e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return response;
    }

    private Response readResponse(HttpURLConnection conn) throws IOException {
        InputStream in;
        Response response;
        block6: {
            response = new Response();
            response.setHeaderFields(conn.getHeaderFields());
            response.setResponseCode(conn.getResponseCode());
            if (conn.getResponseCode() == 204) {
                return response;
            }
            in = null;
            try {
                in = conn.getInputStream();
            }
            catch (IOException ex) {
                Logger.suppress((Throwable)ex);
                in = conn.getErrorStream();
                if (in != null) break block6;
                this.checkResponseCode(conn.getResponseCode(), conn.getResponseMessage());
            }
        }
        try {
            BufferedInputStream bis = new BufferedInputStream(in);
            ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
            int read = 0;
            int bufSize = 4096;
            byte[] buffer = new byte[bufSize];
            while ((read = bis.read(buffer)) != -1) {
                byteArray.write(buffer, 0, read);
            }
            String result = new String(byteArray.toByteArray(), this.encoding);
            response.setResult(result);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return response;
    }

    protected void checkResponseCode(int code, String message) {
        Response.Status status = Response.Status.fromStatusCode((int)code);
        if (code == 500) {
            throw new InternalServerErrorException();
        }
        if (code > 500) {
            throw new ServiceUnavailableException();
        }
        switch (status) {
            case OK: 
            case CREATED: 
            case ACCEPTED: 
            case NO_CONTENT: 
            case RESET_CONTENT: 
            case PARTIAL_CONTENT: {
                return;
            }
            case BAD_REQUEST: {
                throw new BadRequestException(message);
            }
            case UNAUTHORIZED: {
                throw new NotAuthorizedException(javax.ws.rs.core.Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            }
            case PAYMENT_REQUIRED: 
            case FORBIDDEN: {
                throw new ForbiddenException(message);
            }
            case NOT_FOUND: {
                throw new NotFoundException(message);
            }
            case METHOD_NOT_ALLOWED: {
                throw new NotAllowedException(message, javax.ws.rs.core.Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).build());
            }
            case NOT_ACCEPTABLE: {
                throw new NotAcceptableException(message);
            }
            case UNSUPPORTED_MEDIA_TYPE: {
                throw new NotSupportedException(message);
            }
        }
        throw new ServerErrorException(message, status);
    }

    private void printHeaders(Map<String, ?> headers) {
        for (Map.Entry<String, ?> entry : headers.entrySet()) {
            String auth;
            if (entry.getKey() == null) continue;
            this.printer.print(entry.getKey() + ": ");
            if ("Authorization".equals(entry.getKey()) && entry.getValue() instanceof String && (auth = (String)entry.getValue()).startsWith("Bearer ")) {
                this.printer.println("Bearer ...");
                continue;
            }
            boolean first = true;
            if (entry.getValue() instanceof List) {
                for (String item : (List)entry.getValue()) {
                    if (first) {
                        first = false;
                    } else {
                        this.printer.print(", ");
                    }
                    this.printer.print(item);
                }
            } else {
                this.printer.print(entry.getValue());
            }
            this.printer.println();
        }
        this.printer.flush();
    }

    private void setConnectionProperties(HttpURLConnection conn) {
        conn.setDoInput(true);
        conn.setUseCaches(false);
        conn.setAllowUserInteraction(false);
        conn.setRequestProperty("Accept", this.marshaller.getAccept());
    }

    private void loadRequestProperties(HttpURLConnection conn, Properties properties) {
        for (String key : properties.stringPropertyNames()) {
            conn.setRequestProperty(key, properties.getProperty(key));
        }
    }

    private SSLSocketFactory getSSLSocketFactory() {
        if (this.sslSocketFactory != null) {
            return this.sslSocketFactory;
        }
        TrustManager[] trustManagers = null;
        if (this.skipCertCheck) {
            trustManagers = new TrustManager[]{new AcceptAllTrustManager()};
        } else {
            try {
                if (this.trustStore != null) {
                    JavaKeyStore javaKeyStore = new JavaKeyStore(this.trustStore, null, this.trustStoreFormat);
                    javaKeyStore.init(null);
                    trustManagers = javaKeyStore.getTrustManagers();
                } else {
                    TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    factory.init((KeyStore)null);
                    trustManagers = factory.getTrustManagers();
                }
            }
            catch (Exception ex) {
                throw logger.systemException((Throwable)ex);
            }
        }
        SSLContext ctx = null;
        try {
            ctx = SSLContext.getInstance("TLS");
            ctx.init(null, trustManagers, null);
            this.sslSocketFactory = ctx.getSocketFactory();
            return this.sslSocketFactory;
        }
        catch (Exception e) {
            throw logger.systemException((Throwable)e);
        }
    }

    public class AcceptAllTrustManager
    implements X509TrustManager {
        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return EMPTY_CERTIFICATES;
        }
    }
}

