/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster.invocation;

import akka.actor.Status;
import akka.actor.typed.ActorRef;
import net.e6tech.elements.common.actor.typed.Receptor;
import net.e6tech.elements.common.actor.typed.Typed;
import net.e6tech.elements.network.cluster.invocation.InvocationEvents;

public class RegistryEntry
extends Receptor<InvocationEvents.Request, RegistryEntry> {
    private InvocationEvents.Registration registration;

    public RegistryEntry(InvocationEvents.Registration registration) {
        this.registration = registration;
    }

    public void initialize() {
        super.initialize();
        if (this.registration.getSender() != null) {
            this.registration.getSender().tell((Object)this.getSelf());
        }
    }

    @Typed
    private void request(InvocationEvents.Request request) {
        ActorRef sender = request.getSender();
        ActorRef self = this.getSelf();
        try {
            this.talk(request.getTimeout()).async(() -> {
                try {
                    Object ret = this.registration.getFunction().apply(self, request.arguments());
                    sender.tell((Object)new InvocationEvents.Response(self, ret));
                }
                catch (Exception ex) {
                    sender.tell((Object)new Status.Failure((Throwable)ex));
                }
            });
        }
        catch (RuntimeException ex) {
            Throwable throwable = ex.getCause();
            if (throwable == null) {
                throwable = ex;
            }
            sender.tell((Object)new Status.Failure(throwable));
        }
    }
}

