/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.restful;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.e6tech.elements.common.util.ExceptionMapper;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.common.util.concurrent.ObjectPool;

public class Response
implements Serializable {
    private static final long serialVersionUID = 775319303475963086L;
    public static final ObjectMapper mapper = new ObjectMapper();
    public static final ObjectPool<TypeReferenceImpl> objectPool;
    private int responseCode;
    private Map<String, List<String>> headerFields = new HashMap<String, List<String>>();
    private String result;

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public Map<String, List<String>> getHeaderFields() {
        return this.headerFields;
    }

    public void setHeaderFields(Map<String, List<String>> headerFields) {
        this.headerFields = headerFields;
    }

    public <T> T read(Class<T> cls) throws IOException {
        if (this.result == null || cls.isAssignableFrom(String.class)) {
            return (T)this.result;
        }
        return (T)mapper.readValue(this.result, cls);
    }

    public <T> T read(Type type) throws IOException {
        if (this.result == null || type instanceof Class && ((Class)type).isAssignableFrom(String.class)) {
            return (T)this.result;
        }
        try {
            return (T)objectPool.apply(impl -> {
                try (TypeReferenceImpl i = impl;){
                    i.setType(type);
                    Object object = mapper.readValue(this.result, (TypeReference)i);
                    return object;
                }
                catch (Exception e) {
                    throw new SystemException((Throwable)e);
                }
            });
        }
        catch (Exception ex) {
            Throwable th = ExceptionMapper.unwrap((Throwable)ex);
            if (th instanceof IOException) {
                throw (IOException)th;
            }
            throw new IOException(th);
        }
    }

    public String toString() {
        return "responseCode=" + this.responseCode + " headers=" + this.headerFields + " result=" + this.result;
    }

    public boolean isSuccess() {
        return this.getResponseCode() >= 200 && this.getResponseCode() <= 202;
    }

    static {
        mapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        mapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        objectPool = new ObjectPool<TypeReferenceImpl>(){}.limit(200).build();
    }

    public static class TypeReferenceImpl
    extends TypeReference<Object>
    implements AutoCloseable {
        private Type type;

        public Type getType() {
            return this.type;
        }

        protected void setType(Type type) {
            this.type = type;
        }

        @Override
        public void close() {
            this.type = null;
        }
    }
}

