/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.persist.hibernate;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.InstanceNotFoundException;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.serialization.ObjectReference;
import net.e6tech.elements.common.util.InitialContextFactory;
import net.e6tech.elements.persist.EntityManagerConfig;
import net.e6tech.elements.persist.EntityManagerProvider;
import net.e6tech.elements.persist.EvictCollectionRegion;
import net.e6tech.elements.persist.EvictEntity;
import net.e6tech.elements.persist.EvictEntityRegion;
import net.e6tech.elements.persist.PersistenceInterceptor;
import net.e6tech.elements.persist.hibernate.Interceptor;
import org.hibernate.Cache;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.internal.SessionImpl;

public class HibernateEntityManagerProvider
extends EntityManagerProvider {
    private static Logger logger = Logger.getLogger();
    private Map<String, IdentifierGenerator> identifierGenerators = new LinkedHashMap<String, IdentifierGenerator>();
    private net.e6tech.elements.common.interceptor.Interceptor interceptor = new net.e6tech.elements.common.interceptor.Interceptor();

    public void initialize(Resources resources) {
        if (System.getProperty("java.naming.factory.initial") == null) {
            InitialContextFactory.setDefault();
        }
        if (this.identifierGenerators.size() > 0) {
            LinkedHashMap<String, Class> strategies = new LinkedHashMap<String, Class>();
            for (Map.Entry<String, IdentifierGenerator> entry : this.identifierGenerators.entrySet()) {
                Class cls = this.interceptor.newPrototypeClass(entry.getValue().getClass(), (Object)entry.getValue());
                strategies.put(entry.getKey(), cls);
            }
            this.getPersistenceProperties().put("hibernate.ejb.identifier_generator_strategy_provider", () -> strategies);
        }
        super.initialize(resources);
    }

    public HibernateEntityManagerProvider register(String strategy, IdentifierGenerator generator) {
        this.identifierGenerators.put(strategy, generator);
        return this;
    }

    protected void evictCollectionRegion(EvictCollectionRegion notification) {
        javax.persistence.Cache cache = this.emf.getCache();
        Cache hibernateCache = (Cache)cache.unwrap(Cache.class);
        hibernateCache.evictCollectionData(notification.getRole());
    }

    protected void evictEntityRegion(EvictEntityRegion notification) {
        javax.persistence.Cache cache = this.emf.getCache();
        Cache hibernateCache = (Cache)cache.unwrap(Cache.class);
        hibernateCache.evictEntityData(notification.getEntityName());
    }

    protected void evictEntity(EvictEntity notification) {
        javax.persistence.Cache cache = this.emf.getCache();
        Cache hibernateCache = (Cache)cache.unwrap(Cache.class);
        try {
            ObjectReference ref = notification.getObjectReference();
            hibernateCache.evictEntityData(((Object)((Object)this)).getClass().getClassLoader().loadClass(ref.getType()), (Serializable)ref.getId());
        }
        catch (ClassNotFoundException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    protected void onOpen(Resources resources, String alias, EntityManagerConfig config) {
        super.onOpen(resources, alias, config);
        EntityManager em = (EntityManager)resources.getMapVariable(EntityManager.class).get(alias);
        SessionImpl session = (SessionImpl)em.getDelegate();
        resources.getMapVariable(SessionImpl.class).put(alias, session);
        if (session.getInterceptor() instanceof PersistenceInterceptor) {
            PersistenceInterceptor i = (PersistenceInterceptor)session.getInterceptor();
            i.setResources(resources);
            if (i instanceof Interceptor) {
                ((Interceptor)i).setSessionFactory(session.getSessionFactory());
            }
        }
    }

    protected void cleanup(Resources resources, String alias) {
        super.cleanup(resources, alias);
        try {
            SessionImpl session = this.getSessionImpl(resources, alias);
            if (session.getInterceptor() instanceof PersistenceInterceptor) {
                PersistenceInterceptor i = (PersistenceInterceptor)session.getInterceptor();
                i.cleanup(resources);
            }
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
    }

    public void cancelQuery(Resources resources, String alias) {
        super.cancelQuery(resources, alias);
        try {
            this.getSessionImpl(resources, alias).cancelQuery();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private SessionImpl getSessionImpl(Resources resources, String alias) {
        return (SessionImpl)resources.getMapVariable(SessionImpl.class).get(alias);
    }
}

