/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.rules.dataset;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.e6tech.elements.rules.dataset.Calculate;
import net.e6tech.elements.rules.dataset.DataSet;

public class Column
implements Iterable {
    DataSet dataSet;
    String name;
    int columnIndex;
    Class dataType;

    public Column(DataSet dataSet, String name, Class type, int index) {
        this.dataSet = dataSet;
        this.name = name;
        this.columnIndex = index;
        this.dataType = type;
    }

    public String getName() {
        return this.name;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    void setDataType(Class cls) {
        this.dataType = cls;
    }

    public Iterator iterator() {
        return new Itr();
    }

    public BigDecimal sum() {
        Calculate calculate = new Calculate(this.dataType){

            @Override
            public long calculateLong(long current, long value) {
                return current + value;
            }

            @Override
            public double calculateDouble(double current, double value) {
                return current + value;
            }

            @Override
            public BigDecimal calculateBigDecimal(BigDecimal current, BigDecimal value) {
                return current.add(value);
            }
        };
        return calculate.calculate(this);
    }

    public BigDecimal max() {
        Number number = (Number)Collections.max(this.getData());
        if (number == null) {
            return null;
        }
        return new BigDecimal(number.toString());
    }

    public List getData() {
        ArrayList list = new ArrayList();
        for (Object obj : this) {
            list.add(obj);
        }
        return list;
    }

    private class Itr
    implements Iterator {
        int cursor;
        int lastRet = -1;
        int myModCount;

        private Itr() {
            this.myModCount = Column.this.dataSet.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != Column.this.dataSet.getRowSize();
        }

        public Object next() {
            if (this.myModCount != Column.this.dataSet.modCount) {
                throw new ConcurrentModificationException();
            }
            int i = this.cursor;
            if (i >= Column.this.dataSet.getRowSize()) {
                throw new NoSuchElementException();
            }
            this.cursor = i + 1;
            this.lastRet = i;
            return Column.this.dataSet.get(i, Column.this.columnIndex);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

