/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.rules.dataset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.e6tech.elements.rules.dataset.Column;

public class DataSet
implements Map<String, Column> {
    List<List> data = new ArrayList<List>();
    Map<String, Column> columnMap = new LinkedHashMap<String, Column>();
    Column[] columns;
    int modCount = 0;

    public DataSet(String[] col, Class[] columnType) {
        if (col.length != columnType.length) {
            throw new IllegalArgumentException();
        }
        this.columns = new Column[col.length];
        for (int i = 0; i < col.length; ++i) {
            this.columns[i] = new Column(this, col[i], columnType[i], i);
            this.columnMap.put(col[i], this.columns[i]);
        }
    }

    public void addRow(List row) {
        if (row.size() != this.columns.length) {
            throw new IllegalArgumentException();
        }
        ArrayList r = new ArrayList();
        r.addAll(row);
        this.data.add(r);
        this.modCount = this.modCount + 1 & Integer.MAX_VALUE;
    }

    public Object get(int row, int column) {
        if (row >= this.getRowSize()) {
            throw new NoSuchElementException();
        }
        List list = this.data.get(row);
        if (column >= list.size()) {
            throw new NoSuchElementException();
        }
        return list.get(column);
    }

    public void set(int row, int column, Object object) {
        if (row >= this.getRowSize()) {
            throw new NoSuchElementException();
        }
        List list = this.data.get(row);
        if (column >= list.size()) {
            throw new NoSuchElementException();
        }
        list.set(column, object);
        this.modCount = this.modCount + 1 & Integer.MAX_VALUE;
    }

    public int getColumnSize() {
        return this.columnMap.size();
    }

    public int getRowSize() {
        return this.data.size();
    }

    public Column getColumn(String key) {
        return this.columnMap.get(key);
    }

    public Collection<Column> getColumns() {
        return this.columnMap.values();
    }

    @Override
    public int size() {
        return this.getColumnSize();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.columnMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.columnMap.containsValue(value);
    }

    @Override
    public Column get(Object key) {
        return this.columnMap.get(key);
    }

    @Override
    public Column put(String key, Column value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Column remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Column> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        return this.columnMap.keySet();
    }

    @Override
    public Collection<Column> values() {
        return this.getColumns();
    }

    @Override
    public Set<Map.Entry<String, Column>> entrySet() {
        return this.columnMap.entrySet();
    }
}

