/*
 * Decompiled with CFR 0.152.
 */
package net.fastposter.client;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import net.fastposter.client.Buildable;
import net.fastposter.client.Client;
import net.fastposter.client.FastposterException;
import net.fastposter.client.GetPosterArgs;
import net.fastposter.client.Poster;
import net.fastposter.client.PosterBuilder;
import net.fastposter.client.PosterType;
import net.fastposter.client.http.HttpClient;
import net.fastposter.client.utils.Base64Utils;
import net.fastposter.client.utils.JsonUtils;

public class FastposterClient
implements Client,
Buildable {
    private String endpoint;
    private String token;
    private boolean debug;
    private AtomicLong atomicLong;

    private <T> T buildPoster(String uuid, Map<String, Object> params, PosterType type, Double scale, Boolean b64, String userAgent, boolean link) {
        long time = System.currentTimeMillis();
        long seq = this.atomicLong.incrementAndGet();
        String data = JsonUtils.toJson(params);
        String payload = Base64Utils.encodeToString(data.getBytes(StandardCharsets.UTF_8));
        GetPosterArgs.GetPosterArgsBuilder build = GetPosterArgs.builder().uuid(uuid).b64(b64).scale(scale).payload(payload);
        if (type != null) {
            build.type(type.value);
        }
        GetPosterArgs args = build.build();
        if (this.endpoint.endsWith("/")) {
            this.endpoint = this.endpoint.replaceAll("(http.+?)(/{1,})$", "$1");
        }
        String url = this.endpoint + "/v1/build/poster";
        if (link) {
            url = this.endpoint + "/v1/link";
        }
        String json = JsonUtils.toJson(args);
        HttpClient client = new HttpClient();
        HttpClient.Request request = new HttpClient.Request(url, "POST").addHeader("User-Agent", userAgent = userAgent != null && userAgent.length() > 1 ? userAgent : "").addHeader("token", this.token).addHeader("Client-Type", "java").addHeader("Client-Version", "2.2.3").addHeader("Content-Type", "application/json").addHeader("cache-control", "no-cache").setBody(json);
        HttpClient.Response response = client.execute(request);
        if (response.code() != 200) {
            throw new FastposterException(seq, response.code(), " build poster error! \n" + new String(response.body()));
        }
        String contentType = response.header("content-type");
        if (contentType != null && contentType.contains("application/json")) {
            assert (response.body() != null);
            PosterResponse pr = JsonUtils.parseObject(response.body(), PosterResponse.class);
            if (pr.code != 0) {
                throw new FastposterException(seq, pr.code, pr.getMsg());
            }
            if (link) {
                Map data1 = (Map)pr.getData();
                return (T)data1.get("url");
            }
            return null;
        }
        assert (response.body() != null);
        byte[] bytes = response.body();
        long size = bytes.length;
        if (type == null) {
            String rcontentType = response.header("Content-Type");
            type = rcontentType != null && !Objects.equals(contentType, "") ? (rcontentType.contains("jpeg") ? PosterType.jpeg : (rcontentType.contains("pdf") ? PosterType.pdf : (rcontentType.contains("png") ? PosterType.png : (rcontentType.contains("jpg") ? PosterType.jpg : PosterType.jpg)))) : PosterType.jpg;
        }
        if (this.debug) {
            time = System.currentTimeMillis() - time;
            System.out.println(SDF.format(new Date()) + " " + seq + " build poster completed. uuid=" + uuid + " type=" + (Object)((Object)type) + " " + (type.value.length() <= 3 ? " " : "") + "size=" + size + " rt=" + time + "ms" + (b64 != null && b64 != false ? " b64=" + b64 : "") + (scale != null ? " scale=" + scale : ""));
        }
        return (T)new Poster(uuid, type, bytes, b64);
    }

    @Override
    public PosterBuilder buildPoster(String uuid) {
        return PosterBuilder.builder().client(this).uuid(uuid).build();
    }

    @Override
    public Poster build(PosterBuilder posterBuilder) {
        return (Poster)this.buildPoster(posterBuilder.uuid, posterBuilder.params, posterBuilder.type, posterBuilder.scale, posterBuilder.b64, posterBuilder.userAgent, false);
    }

    @Override
    public String buildLink(PosterBuilder posterBuilder) {
        return (String)this.buildPoster(posterBuilder.uuid, posterBuilder.params, posterBuilder.type, posterBuilder.scale, posterBuilder.b64, posterBuilder.userAgent, true);
    }

    private static String $default$endpoint() {
        return "https://api.fastposter.net";
    }

    private static AtomicLong $default$atomicLong() {
        return new AtomicLong(0L);
    }

    FastposterClient(String endpoint, String token, boolean debug, AtomicLong atomicLong) {
        this.endpoint = endpoint;
        this.token = token;
        this.debug = debug;
        this.atomicLong = atomicLong;
    }

    public static FastposterClientBuilder builder() {
        return new FastposterClientBuilder();
    }

    public static class FastposterClientBuilder {
        private boolean endpoint$set;
        private String endpoint$value;
        private String token;
        private boolean debug;
        private boolean atomicLong$set;
        private AtomicLong atomicLong$value;

        FastposterClientBuilder() {
        }

        public FastposterClientBuilder endpoint(String endpoint) {
            this.endpoint$value = endpoint;
            this.endpoint$set = true;
            return this;
        }

        public FastposterClientBuilder token(String token) {
            this.token = token;
            return this;
        }

        public FastposterClientBuilder debug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public FastposterClientBuilder atomicLong(AtomicLong atomicLong) {
            this.atomicLong$value = atomicLong;
            this.atomicLong$set = true;
            return this;
        }

        public FastposterClient build() {
            String endpoint$value = this.endpoint$value;
            if (!this.endpoint$set) {
                endpoint$value = FastposterClient.$default$endpoint();
            }
            AtomicLong atomicLong$value = this.atomicLong$value;
            if (!this.atomicLong$set) {
                atomicLong$value = FastposterClient.$default$atomicLong();
            }
            return new FastposterClient(endpoint$value, this.token, this.debug, atomicLong$value);
        }

        public String toString() {
            return "FastposterClient.FastposterClientBuilder(endpoint$value=" + this.endpoint$value + ", token=" + this.token + ", debug=" + this.debug + ", atomicLong$value=" + this.atomicLong$value + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class PosterResponse {
        int code;
        String msg;
        Object data;
        String traceId;

        public int getCode() {
            return this.code;
        }

        public String getMsg() {
            return this.msg;
        }

        public Object getData() {
            return this.data;
        }

        public String getTraceId() {
            return this.traceId;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PosterResponse)) {
                return false;
            }
            PosterResponse other = (PosterResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCode() != other.getCode()) {
                return false;
            }
            String this$msg = this.getMsg();
            String other$msg = other.getMsg();
            if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
                return false;
            }
            Object this$data = this.getData();
            Object other$data = other.getData();
            if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                return false;
            }
            String this$traceId = this.getTraceId();
            String other$traceId = other.getTraceId();
            return !(this$traceId == null ? other$traceId != null : !this$traceId.equals(other$traceId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PosterResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCode();
            String $msg = this.getMsg();
            result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
            Object $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            String $traceId = this.getTraceId();
            result = result * 59 + ($traceId == null ? 43 : $traceId.hashCode());
            return result;
        }

        public String toString() {
            return "FastposterClient.PosterResponse(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ", traceId=" + this.getTraceId() + ")";
        }
    }
}

