/*
 * Decompiled with CFR 0.152.
 */
package net.fastposter.client.http;

import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fastposter.client.utils.IOUtils;

public class HttpClient {
    public Response execute(Request request) throws Exception {
        URL url = new URL(request.getUrl());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(request.getMethod());
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            connection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        if ("POST".equalsIgnoreCase(request.getMethod()) && request.getBody() != null) {
            connection.setDoOutput(true);
            Throwable throwable = null;
            try (OutputStream os = connection.getOutputStream();){
                byte[] input = request.getBody().getBytes("utf-8");
                os.write(input, 0, input.length);
            }
            catch (Throwable input) {
                Throwable throwable2 = input;
                throw input;
            }
        }
        int statusCode = connection.getResponseCode();
        byte[] byArray = IOUtils.toByteArray(connection.getInputStream());
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : connection.getHeaderFields().entrySet()) {
            if (entry.getKey() == null) continue;
            responseHeaders.put(entry.getKey(), String.join((CharSequence)", ", (Iterable<? extends CharSequence>)entry.getValue()));
        }
        return new Response(statusCode, byArray, responseHeaders);
    }

    public static class Response {
        private int statusCode;
        private byte[] body;
        private Map<String, String> headers;

        public Response(int statusCode, byte[] body, Map<String, String> headers) {
            this.statusCode = statusCode;
            this.body = body;
            this.headers = headers;
        }

        public int code() {
            return this.statusCode;
        }

        public byte[] body() {
            return this.body;
        }

        public String header(String name) {
            return this.headers.entrySet().stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase(name)).findFirst().map(Map.Entry::getValue).orElse(null);
        }
    }

    public static class Request {
        private String url;
        private String method;
        private Map<String, String> headers = new HashMap<String, String>();
        private String body;

        public Request(String url, String method) {
            this.url = url;
            this.method = method;
        }

        public Request addHeader(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        public Request setBody(String body) {
            this.body = body;
            return this;
        }

        public String getUrl() {
            return this.url;
        }

        public String getMethod() {
            return this.method;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public String getBody() {
            return this.body;
        }
    }
}

