/*
 * Decompiled with CFR 0.152.
 */
package net.fastposter.client;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.fastposter.client.FastpsoterException;
import net.fastposter.client.GetPosterArgs;
import net.fastposter.client.Poster;
import net.fastposter.client.PosterBuilder;
import net.fastposter.client.PosterType;
import net.fastposter.client.utils.Base64Utils;
import net.fastposter.client.utils.DigestUtils;
import net.fastposter.client.utils.JsonUtils;
import net.fastposter.client.utils.RandomUtils;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class FastposterCloudClient {
    private static final String CLIENT_TYPE = "java";
    private static final String CLIENT_VERSION = "1.3.2";
    private static final String USER_AGENT = "fastposter-cloud-client/1.3.2 (java)";
    private final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private OkHttpClient okHttpClient;
    private String endpoint;
    private String appKey;
    private String appSecret;
    private boolean debug;
    private boolean trace;
    private static final OkHttpClient DEFAULT_OK_HTTP_CLIENT = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).build();
    private AtomicLong atomicLong;

    private <T> T buildPoster(String uuid, Map<String, Object> params, PosterType type, Double scale, Boolean b64, String userAgent, boolean onlySign) {
        long time = System.currentTimeMillis();
        long seq = this.atomicLong.incrementAndGet();
        String data = JsonUtils.toJson(params);
        String playload = Base64Utils.encodeToString(data.getBytes());
        Long timestamp = System.currentTimeMillis() / 1000L;
        String nonce = RandomUtils.randomAlphanumeric(16);
        String sign = DigestUtils.md5DigestAsHex((playload + timestamp + nonce + this.appSecret).getBytes());
        GetPosterArgs.GetPosterArgsBuilder build = GetPosterArgs.builder().uuid(uuid).b64(b64).scale(scale).timestamp(timestamp).nonce(nonce).appKey(this.appKey).sign(sign).payload(playload);
        if (type != null) {
            build.type(type.value);
        }
        GetPosterArgs args = build.build();
        String url = this.endpoint + "/v1/build/poster";
        MediaType mediaType = MediaType.parse((String)"application/json");
        String json = JsonUtils.toJson(args);
        if (onlySign) {
            return (T)args;
        }
        if (this.trace) {
            System.out.println(this.SDF.format(new Date()) + " " + seq + " build poster request=" + json);
        }
        userAgent = userAgent != null && userAgent.length() > 1 ? userAgent : USER_AGENT;
        RequestBody body = RequestBody.create((String)json, (MediaType)mediaType);
        Request request = new Request.Builder().url(url).post(body).addHeader("User-Agent", userAgent).addHeader("Client-Type", CLIENT_TYPE).addHeader("Client-Version", CLIENT_VERSION).addHeader("Content-Type", "application/json").addHeader("cache-control", "no-cache").build();
        Response response = this.okHttpClient().newCall(request).execute();
        String traceId = response.header("fastposter-cloud-traceid");
        if (this.trace) {
            response.headers().forEach(a -> System.out.println((String)a.getFirst() + ":" + (String)a.getSecond()));
        }
        if (response.code() != 200) {
            throw new FastpsoterException(seq, response.code(), " build poster error! \n" + response.body().string(), traceId);
        }
        String contentType = response.header("content-type");
        if (contentType != null && contentType.contains("application/json")) {
            assert (response.body() != null);
            PosterResponse pr = JsonUtils.parseObject(response.body().bytes(), PosterResponse.class);
            if (pr.code != 0) {
                throw new FastpsoterException(seq, pr.code, pr.getMsg(), traceId);
            }
            return null;
        }
        assert (response.body() != null);
        byte[] bytes = response.body().bytes();
        long size = bytes.length;
        if (type == null) {
            String rcontentType = response.header("Content-Type");
            type = rcontentType != null && !Objects.equals(contentType, "") ? (rcontentType.contains("jpeg") ? PosterType.jpeg : (rcontentType.contains("pdf") ? PosterType.pdf : (rcontentType.contains("png") ? PosterType.png : (rcontentType.contains("jpg") ? PosterType.jpg : PosterType.jpg)))) : PosterType.jpg;
        }
        if (this.debug) {
            time = System.currentTimeMillis() - time;
            System.out.println(this.SDF.format(new Date()) + " " + seq + " build poster completed. traceId=" + traceId + " uuid=" + uuid + " type=" + (Object)((Object)type) + " " + (type.value.length() <= 3 ? " " : "") + "size=" + size + " rt=" + time + "ms" + (b64 != null && b64 != false ? " b64=" + b64 : "") + (scale != null ? " scale=" + scale : ""));
        }
        return (T)new Poster(traceId, type, bytes, b64);
    }

    private OkHttpClient okHttpClient() {
        if (this.okHttpClient == null) {
            this.okHttpClient = DEFAULT_OK_HTTP_CLIENT;
        }
        return this.okHttpClient;
    }

    public PosterBuilder buildPoster(String uuid) {
        return PosterBuilder.builder().client(this).uuid(uuid).build();
    }

    protected Poster build(PosterBuilder posterBuilder) {
        return (Poster)this.buildPoster(posterBuilder.uuid, posterBuilder.params, posterBuilder.type, posterBuilder.scale, posterBuilder.b64, posterBuilder.userAgent, false);
    }

    protected GetPosterArgs getArgs(PosterBuilder posterBuilder) {
        return (GetPosterArgs)this.buildPoster(posterBuilder.uuid, posterBuilder.params, posterBuilder.type, posterBuilder.scale, posterBuilder.b64, posterBuilder.userAgent, true);
    }

    private static String $default$endpoint() {
        return "https://api.fastposter.net";
    }

    private static AtomicLong $default$atomicLong() {
        return new AtomicLong(0L);
    }

    FastposterCloudClient(OkHttpClient okHttpClient, String endpoint, String appKey, String appSecret, boolean debug, boolean trace, AtomicLong atomicLong) {
        this.okHttpClient = okHttpClient;
        this.endpoint = endpoint;
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.debug = debug;
        this.trace = trace;
        this.atomicLong = atomicLong;
    }

    public static FastposterCloudClientBuilder builder() {
        return new FastposterCloudClientBuilder();
    }

    public static class FastposterCloudClientBuilder {
        private OkHttpClient okHttpClient;
        private boolean endpoint$set;
        private String endpoint$value;
        private String appKey;
        private String appSecret;
        private boolean debug;
        private boolean trace;
        private boolean atomicLong$set;
        private AtomicLong atomicLong$value;

        FastposterCloudClientBuilder() {
        }

        public FastposterCloudClientBuilder okHttpClient(OkHttpClient okHttpClient) {
            this.okHttpClient = okHttpClient;
            return this;
        }

        public FastposterCloudClientBuilder endpoint(String endpoint) {
            this.endpoint$value = endpoint;
            this.endpoint$set = true;
            return this;
        }

        public FastposterCloudClientBuilder appKey(String appKey) {
            this.appKey = appKey;
            return this;
        }

        public FastposterCloudClientBuilder appSecret(String appSecret) {
            this.appSecret = appSecret;
            return this;
        }

        public FastposterCloudClientBuilder debug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public FastposterCloudClientBuilder trace(boolean trace) {
            this.trace = trace;
            return this;
        }

        public FastposterCloudClientBuilder atomicLong(AtomicLong atomicLong) {
            this.atomicLong$value = atomicLong;
            this.atomicLong$set = true;
            return this;
        }

        public FastposterCloudClient build() {
            String endpoint$value = this.endpoint$value;
            if (!this.endpoint$set) {
                endpoint$value = FastposterCloudClient.$default$endpoint();
            }
            AtomicLong atomicLong$value = this.atomicLong$value;
            if (!this.atomicLong$set) {
                atomicLong$value = FastposterCloudClient.$default$atomicLong();
            }
            return new FastposterCloudClient(this.okHttpClient, endpoint$value, this.appKey, this.appSecret, this.debug, this.trace, atomicLong$value);
        }

        public String toString() {
            return "FastposterCloudClient.FastposterCloudClientBuilder(okHttpClient=" + this.okHttpClient + ", endpoint$value=" + this.endpoint$value + ", appKey=" + this.appKey + ", appSecret=" + this.appSecret + ", debug=" + this.debug + ", trace=" + this.trace + ", atomicLong$value=" + this.atomicLong$value + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class PosterResponse {
        int code;
        String msg;
        Object data;
        String traceId;

        public int getCode() {
            return this.code;
        }

        public String getMsg() {
            return this.msg;
        }

        public Object getData() {
            return this.data;
        }

        public String getTraceId() {
            return this.traceId;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PosterResponse)) {
                return false;
            }
            PosterResponse other = (PosterResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCode() != other.getCode()) {
                return false;
            }
            String this$msg = this.getMsg();
            String other$msg = other.getMsg();
            if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
                return false;
            }
            Object this$data = this.getData();
            Object other$data = other.getData();
            if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                return false;
            }
            String this$traceId = this.getTraceId();
            String other$traceId = other.getTraceId();
            return !(this$traceId == null ? other$traceId != null : !this$traceId.equals(other$traceId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PosterResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCode();
            String $msg = this.getMsg();
            result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
            Object $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            String $traceId = this.getTraceId();
            result = result * 59 + ($traceId == null ? 43 : $traceId.hashCode());
            return result;
        }

        public String toString() {
            return "FastposterCloudClient.PosterResponse(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ", traceId=" + this.getTraceId() + ")";
        }
    }
}

