/*
 * Decompiled with CFR 0.152.
 */
package net.fastposter.client;

import java.util.HashMap;
import java.util.Map;
import net.fastposter.client.FastposterCloudClient;
import net.fastposter.client.GetPosterArgs;
import net.fastposter.client.Poster;
import net.fastposter.client.PosterType;

public class PosterBuilder {
    String uuid;
    PosterType type;
    Double scale = 1.0;
    Boolean b64;
    String userAgent;
    protected Map<String, Object> params;
    FastposterCloudClient client;

    public PosterBuilder add(String name, Object value) {
        this.params.put(name, value);
        return this;
    }

    public PosterBuilder put(String name, Object value) {
        this.params.put(name, value);
        return this;
    }

    public Poster build() {
        return this.client.build(this);
    }

    public PosterBuilder params(Map<String, Object> params) {
        this.params = params;
        return this;
    }

    public PosterBuilder b64() {
        this.b64 = true;
        return this;
    }

    private PosterBuilder type(PosterType posterType) {
        assert (posterType != null);
        this.type = posterType;
        return this;
    }

    public PosterBuilder type(String type) {
        assert (type != null);
        this.type = Enum.valueOf(PosterType.class, type.trim().toLowerCase());
        return this;
    }

    public PosterBuilder png() {
        this.type = PosterType.png;
        return this;
    }

    public PosterBuilder jpg() {
        this.type = PosterType.jpg;
        return this;
    }

    public PosterBuilder jpeg() {
        this.type = PosterType.jpeg;
        return this;
    }

    public PosterBuilder pdf() {
        this.type = PosterType.pdf;
        return this;
    }

    public PosterBuilder webp() {
        this.type = PosterType.webp;
        return this;
    }

    public PosterBuilder scale(double scale) {
        this.scale = scale;
        return this;
    }

    public GetPosterArgs getArgs() {
        return this.client.getArgs(this);
    }

    public PosterBuilder userAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    private static Map<String, Object> $default$params() {
        return new HashMap<String, Object>();
    }

    PosterBuilder(String uuid, PosterType type, Double scale, Boolean b64, String userAgent, Map<String, Object> params, FastposterCloudClient client) {
        this.uuid = uuid;
        this.type = type;
        this.scale = scale;
        this.b64 = b64;
        this.userAgent = userAgent;
        this.params = params;
        this.client = client;
    }

    public static PosterBuilderBuilder builder() {
        return new PosterBuilderBuilder();
    }

    public static class PosterBuilderBuilder {
        private String uuid;
        private PosterType type;
        private Double scale;
        private Boolean b64;
        private String userAgent;
        private boolean params$set;
        private Map<String, Object> params$value;
        private FastposterCloudClient client;

        PosterBuilderBuilder() {
        }

        public PosterBuilderBuilder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public PosterBuilderBuilder type(PosterType type) {
            this.type = type;
            return this;
        }

        public PosterBuilderBuilder scale(Double scale) {
            this.scale = scale;
            return this;
        }

        public PosterBuilderBuilder b64(Boolean b64) {
            this.b64 = b64;
            return this;
        }

        public PosterBuilderBuilder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public PosterBuilderBuilder params(Map<String, Object> params) {
            this.params$value = params;
            this.params$set = true;
            return this;
        }

        public PosterBuilderBuilder client(FastposterCloudClient client) {
            this.client = client;
            return this;
        }

        public PosterBuilder build() {
            Map params$value = this.params$value;
            if (!this.params$set) {
                params$value = PosterBuilder.$default$params();
            }
            return new PosterBuilder(this.uuid, this.type, this.scale, this.b64, this.userAgent, params$value, this.client);
        }

        public String toString() {
            return "PosterBuilder.PosterBuilderBuilder(uuid=" + this.uuid + ", type=" + (Object)((Object)this.type) + ", scale=" + this.scale + ", b64=" + this.b64 + ", userAgent=" + this.userAgent + ", params$value=" + this.params$value + ", client=" + this.client + ")";
        }
    }
}

