/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import java.util.Optional;
import net.finmath.smartcontract.api.ApiUtil;
import net.finmath.smartcontract.model.CashflowPeriod;
import net.finmath.smartcontract.model.Error;
import net.finmath.smartcontract.model.MarketDataSet;
import net.finmath.smartcontract.model.PlainSwapOperationRequest;
import net.finmath.smartcontract.model.SaveContractRequest;
import net.finmath.smartcontract.model.ValueResult;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

@Validated
@Tag(name="plainSwapEditor", description="the plainSwapEditor API")
public interface PlainSwapEditorApi {
    default public Optional<NativeWebRequest> getRequest() {
        return Optional.empty();
    }

    @Operation(operationId="changeDataset", summary="Request a saved contract.", tags={"plainSwapEditor"}, responses={@ApiResponse(responseCode="200", description="Fetch successful.", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class)), @Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="default", description="unexpected error", content={@Content(mediaType="text/plain", schema=@Schema(implementation=Error.class)), @Content(mediaType="application/json", schema=@Schema(implementation=Error.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/plain-swap-editor/change-dataset"}, produces={"text/plain", "application/json"}, consumes={"application/json"})
    default public ResponseEntity<String> _changeDataset(@Parameter(name="body", description="") @Valid @RequestBody(required=false) String body) {
        return this.changeDataset(body);
    }

    default public ResponseEntity<String> changeDataset(String body) {
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="evaluateFromPlainSwapEditor", summary="Request mapping for valuation of the trade data coming from the editor.", tags={"plainSwapEditor"}, responses={@ApiResponse(responseCode="200", description="Valuation successful.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ValueResult.class))}), @ApiResponse(responseCode="default", description="unexpected error", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/plain-swap-editor/evaluate-from-editor"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<ValueResult> _evaluateFromPlainSwapEditor(@Parameter(name="PlainSwapOperationRequest", description="") @Valid @RequestBody(required=false) PlainSwapOperationRequest plainSwapOperationRequest) {
        return this.evaluateFromPlainSwapEditor(plainSwapOperationRequest);
    }

    default public ResponseEntity<ValueResult> evaluateFromPlainSwapEditor(PlainSwapOperationRequest plainSwapOperationRequest) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"valuationDate\" : \"valuationDate\", \"currency\" : \"currency\", \"value\" : 0.8008281904610115 }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="generatePlainSwapSdcml", summary="Request mapping for generation of the trade data SDCmL", tags={"plainSwapEditor"}, responses={@ApiResponse(responseCode="200", description="SDCmL was generated", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class)), @Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="default", description="unexpected error", content={@Content(mediaType="text/plain", schema=@Schema(implementation=Error.class)), @Content(mediaType="application/json", schema=@Schema(implementation=Error.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/plain-swap-editor/generate-xml"}, produces={"text/plain", "application/json"}, consumes={"application/json"})
    default public ResponseEntity<String> _generatePlainSwapSdcml(@Parameter(name="PlainSwapOperationRequest", description="") @Valid @RequestBody(required=false) PlainSwapOperationRequest plainSwapOperationRequest) {
        return this.generatePlainSwapSdcml(plainSwapOperationRequest);
    }

    default public ResponseEntity<String> generatePlainSwapSdcml(PlainSwapOperationRequest plainSwapOperationRequest) {
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getFixedSchedule", summary="Request payment schedule for the fixed leg defined in the editor.", tags={"plainSwapEditor"}, responses={@ApiResponse(responseCode="200", description="Schedule generation successful.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=CashflowPeriod.class)))}), @ApiResponse(responseCode="default", description="unexpected error", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/plain-swap-editor/get-fixed-schedule"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<List<CashflowPeriod>> _getFixedSchedule(@Parameter(name="PlainSwapOperationRequest", description="") @Valid @RequestBody(required=false) PlainSwapOperationRequest plainSwapOperationRequest) {
        return this.getFixedSchedule(plainSwapOperationRequest);
    }

    default public ResponseEntity<List<CashflowPeriod>> getFixedSchedule(PlainSwapOperationRequest plainSwapOperationRequest) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "[ { \"rate\" : 0.8008281904610115, \"cashflow\" : { \"valuationDate\" : \"valuationDate\", \"currency\" : \"currency\", \"value\" : 0.8008281904610115 }, \"fixingDate\" : \"2000-01-23T04:56:07.000+00:00\", \"paymentDate\" : \"2000-01-23T04:56:07.000+00:00\", \"periodStart\" : \"2000-01-23T04:56:07.000+00:00\", \"periodEnd\" : \"2000-01-23T04:56:07.000+00:00\" }, { \"rate\" : 0.8008281904610115, \"cashflow\" : { \"valuationDate\" : \"valuationDate\", \"currency\" : \"currency\", \"value\" : 0.8008281904610115 }, \"fixingDate\" : \"2000-01-23T04:56:07.000+00:00\", \"paymentDate\" : \"2000-01-23T04:56:07.000+00:00\", \"periodStart\" : \"2000-01-23T04:56:07.000+00:00\", \"periodEnd\" : \"2000-01-23T04:56:07.000+00:00\" } ]";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getFloatingSchedule", summary="Request payment schedule for the floating leg defined in the editor.", tags={"plainSwapEditor"}, responses={@ApiResponse(responseCode="200", description="Schedule generation successful.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=CashflowPeriod.class)))}), @ApiResponse(responseCode="default", description="unexpected error", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/plain-swap-editor/get-floating-schedule"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<List<CashflowPeriod>> _getFloatingSchedule(@Parameter(name="PlainSwapOperationRequest", description="") @Valid @RequestBody(required=false) PlainSwapOperationRequest plainSwapOperationRequest) {
        return this.getFloatingSchedule(plainSwapOperationRequest);
    }

    default public ResponseEntity<List<CashflowPeriod>> getFloatingSchedule(PlainSwapOperationRequest plainSwapOperationRequest) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "[ { \"rate\" : 0.8008281904610115, \"cashflow\" : { \"valuationDate\" : \"valuationDate\", \"currency\" : \"currency\", \"value\" : 0.8008281904610115 }, \"fixingDate\" : \"2000-01-23T04:56:07.000+00:00\", \"paymentDate\" : \"2000-01-23T04:56:07.000+00:00\", \"periodStart\" : \"2000-01-23T04:56:07.000+00:00\", \"periodEnd\" : \"2000-01-23T04:56:07.000+00:00\" }, { \"rate\" : 0.8008281904610115, \"cashflow\" : { \"valuationDate\" : \"valuationDate\", \"currency\" : \"currency\", \"value\" : 0.8008281904610115 }, \"fixingDate\" : \"2000-01-23T04:56:07.000+00:00\", \"paymentDate\" : \"2000-01-23T04:56:07.000+00:00\", \"periodStart\" : \"2000-01-23T04:56:07.000+00:00\", \"periodEnd\" : \"2000-01-23T04:56:07.000+00:00\" } ]";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getParRate", summary="Request the par rate for the swap defined in the editor.", tags={"plainSwapEditor"}, responses={@ApiResponse(responseCode="200", description="Schedule generation successful.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Double.class))}), @ApiResponse(responseCode="default", description="unexpected error", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/plain-swap-editor/get-par-rate"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<Double> _getParRate(@Parameter(name="PlainSwapOperationRequest", description="") @Valid @RequestBody(required=false) PlainSwapOperationRequest plainSwapOperationRequest) {
        return this.getParRate(plainSwapOperationRequest);
    }

    default public ResponseEntity<Double> getParRate(PlainSwapOperationRequest plainSwapOperationRequest) {
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getSavedContracts", summary="Request the list of saved contracts.", tags={"plainSwapEditor"}, responses={@ApiResponse(responseCode="200", description="Fetch successful.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=String.class)))}), @ApiResponse(responseCode="default", description="unexpected error", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=String.class)))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/plain-swap-editor/get-saved-contracts"}, produces={"application/json"})
    default public ResponseEntity<List<String>> _getSavedContracts() {
        return this.getSavedContracts();
    }

    default public ResponseEntity<List<String>> getSavedContracts() {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "[ \"\", \"\" ]";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getSavedMarketData", summary="Request the list of saved market data.", tags={"plainSwapEditor"}, responses={@ApiResponse(responseCode="200", description="Fetch successful.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=String.class)))}), @ApiResponse(responseCode="default", description="unexpected error", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=String.class)))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/plain-swap-editor/get-saved-market-data"}, produces={"application/json"})
    default public ResponseEntity<List<String>> _getSavedMarketData() {
        return this.getSavedMarketData();
    }

    default public ResponseEntity<List<String>> getSavedMarketData() {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "[ \"\", \"\" ]";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="grabMarketData", summary="Request mapping for transferring the active dataset to the client", tags={"plainSwapEditor"}, responses={@ApiResponse(responseCode="200", description="Valuation successful.", content={@Content(mediaType="application/json", schema=@Schema(implementation=MarketDataSet.class))}), @ApiResponse(responseCode="default", description="unexpected error", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/plain-swap-editor/grab-market-data"}, produces={"application/json"})
    default public ResponseEntity<MarketDataSet> _grabMarketData() {
        return this.grabMarketData();
    }

    default public ResponseEntity<MarketDataSet> grabMarketData() {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"requestTimestamp\" : \"2000-01-23T04:56:07.000+00:00\", \"values\" : [ { \"symbol\" : \"symbol\", \"dataTimestamp\" : \"2000-01-23T04:56:07.000+00:00\", \"value\" : 0.8008281904610115 }, { \"symbol\" : \"symbol\", \"dataTimestamp\" : \"2000-01-23T04:56:07.000+00:00\", \"value\" : 0.8008281904610115 } ] }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="loadContract", summary="Request a saved contract.", tags={"plainSwapEditor"}, responses={@ApiResponse(responseCode="200", description="Fetch successful.", content={@Content(mediaType="application/json", schema=@Schema(implementation=PlainSwapOperationRequest.class))}), @ApiResponse(responseCode="default", description="unexpected error", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/plain-swap-editor/load-contract"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<PlainSwapOperationRequest> _loadContract(@Parameter(name="body", description="") @Valid @RequestBody(required=false) String body) {
        return this.loadContract(body);
    }

    default public ResponseEntity<PlainSwapOperationRequest> loadContract(String body) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"notionalAmount\" : 0.14658129805029452, \"floatingPaymentFrequency\" : { \"period\" : \"period\", \"fullName\" : \"fullName\", \"periodMultiplier\" : 1 }, \"currentGenerator\" : \"currentGenerator\", \"valuationSymbols\" : [ { \"symbol\" : \"symbol\", \"itemType\" : \"itemType\", \"tenor\" : \"tenor\", \"curve\" : \"curve\" }, { \"symbol\" : \"symbol\", \"itemType\" : \"itemType\", \"tenor\" : \"tenor\", \"curve\" : \"curve\" } ], \"terminationFeeAmount\" : 0.6027456183070403, \"fixedDayCountFraction\" : \"fixedDayCountFraction\", \"tradeDate\" : \"2000-01-23T04:56:07.000+00:00\", \"firstCounterparty\" : { \"baseUrl\" : \"http://example.com/aeiou\", \"fullName\" : \"fullName\", \"bicCode\" : \"bicCode\" }, \"secondCounterparty\" : { \"baseUrl\" : \"http://example.com/aeiou\", \"fullName\" : \"fullName\", \"bicCode\" : \"bicCode\" }, \"floatingPayingParty\" : { \"baseUrl\" : \"http://example.com/aeiou\", \"fullName\" : \"fullName\", \"bicCode\" : \"bicCode\" }, \"terminationDate\" : \"2000-01-23T04:56:07.000+00:00\", \"fixedPaymentFrequency\" : { \"period\" : \"period\", \"fullName\" : \"fullName\", \"periodMultiplier\" : 1 }, \"uniqueTradeIdentifier\" : \"uniqueTradeIdentifier\", \"marginBufferAmount\" : 0.08008281904610115, \"fixedPayingParty\" : { \"baseUrl\" : \"http://example.com/aeiou\", \"fullName\" : \"fullName\", \"bicCode\" : \"bicCode\" }, \"fixedRate\" : 5.962133916683182, \"currency\" : \"currency\", \"floatingDayCountFraction\" : \"floatingDayCountFraction\", \"floatingFixingDayOffset\" : -1, \"effectiveDate\" : \"2000-01-23T04:56:07.000+00:00\", \"floatingRateIndex\" : \"floatingRateIndex\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="refreshMarketData", summary="Request mapping for valuation of the trade data coming from the editor.", tags={"plainSwapEditor"}, responses={@ApiResponse(responseCode="200", description="Valuation successful.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ValueResult.class))}), @ApiResponse(responseCode="default", description="unexpected error", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/plain-swap-editor/refresh-market-data"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<ValueResult> _refreshMarketData(@Parameter(name="PlainSwapOperationRequest", description="") @Valid @RequestBody(required=false) PlainSwapOperationRequest plainSwapOperationRequest) {
        return this.refreshMarketData(plainSwapOperationRequest);
    }

    default public ResponseEntity<ValueResult> refreshMarketData(PlainSwapOperationRequest plainSwapOperationRequest) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"valuationDate\" : \"valuationDate\", \"currency\" : \"currency\", \"value\" : 0.8008281904610115 }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="saveContract", summary="Request to save a contract.", tags={"plainSwapEditor"}, responses={@ApiResponse(responseCode="200", description="Save successful.", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class)), @Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="default", description="unexpected error", content={@Content(mediaType="text/plain", schema=@Schema(implementation=Error.class)), @Content(mediaType="application/json", schema=@Schema(implementation=Error.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/plain-swap-editor/save-contract"}, produces={"text/plain", "application/json"}, consumes={"application/json"})
    default public ResponseEntity<String> _saveContract(@Parameter(name="SaveContractRequest", description="") @Valid @RequestBody(required=false) SaveContractRequest saveContractRequest) {
        return this.saveContract(saveContractRequest);
    }

    default public ResponseEntity<String> saveContract(SaveContractRequest saveContractRequest) {
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="uploadMarketData", summary="Request to upload market data", tags={"plainSwapEditor"}, responses={@ApiResponse(responseCode="200", description="Upload successful.", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class)), @Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="default", description="unexpected error", content={@Content(mediaType="text/plain", schema=@Schema(implementation=Error.class)), @Content(mediaType="application/json", schema=@Schema(implementation=Error.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/plain-swap-editor/upload-market-data"}, produces={"text/plain", "application/json"}, consumes={"multipart/form-data"})
    default public ResponseEntity<String> _uploadMarketData(@Parameter(name="tradeData", description="", required=true) @RequestPart(value="tradeData", required=true) MultipartFile tradeData) {
        return this.uploadMarketData(tradeData);
    }

    default public ResponseEntity<String> uploadMarketData(MultipartFile tradeData) {
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }
}

