/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.Optional;
import net.finmath.smartcontract.api.ApiUtil;
import net.finmath.smartcontract.model.Error;
import net.finmath.smartcontract.model.InitialSettlementRequest;
import net.finmath.smartcontract.model.InitialSettlementResult;
import net.finmath.smartcontract.model.RegularSettlementRequest;
import net.finmath.smartcontract.model.RegularSettlementResult;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.request.NativeWebRequest;

@Validated
@Tag(name="settlement", description="the settlement API")
public interface SettlementApi {
    default public Optional<NativeWebRequest> getRequest() {
        return Optional.empty();
    }

    @Operation(operationId="generateInitialSettlementResult", summary="generate an initial settlement xml based on given product xml", responses={@ApiResponse(responseCode="200", description="initial settlement xml was created", content={@Content(mediaType="application/json", schema=@Schema(implementation=InitialSettlementResult.class))}), @ApiResponse(responseCode="default", description="unexpected error", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/settlement/generate-initial-settlement"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<InitialSettlementResult> _generateInitialSettlementResult(@Parameter(name="InitialSettlementRequest", description="") @Valid @RequestBody(required=false) InitialSettlementRequest initialSettlementRequest) {
        return this.generateInitialSettlementResult(initialSettlementRequest);
    }

    default public ResponseEntity<InitialSettlementResult> generateInitialSettlementResult(InitialSettlementRequest initialSettlementRequest) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"marginValue\" : 0.8008281904610115, \"valuationDate\" : \"valuationDate\", \"currency\" : \"currency\", \"generatedInitialSettlement\" : \"generatedInitialSettlement\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="generateRegularSettlementResult", summary="generate a regular settlement xml based on given settlement and product xml", responses={@ApiResponse(responseCode="200", description="regular settlement xml was created", content={@Content(mediaType="application/json", schema=@Schema(implementation=RegularSettlementResult.class))}), @ApiResponse(responseCode="default", description="unexpected error", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/settlement/generate-regular-settlement"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<RegularSettlementResult> _generateRegularSettlementResult(@Parameter(name="RegularSettlementRequest", description="") @Valid @RequestBody(required=false) RegularSettlementRequest regularSettlementRequest) {
        return this.generateRegularSettlementResult(regularSettlementRequest);
    }

    default public ResponseEntity<RegularSettlementResult> generateRegularSettlementResult(RegularSettlementRequest regularSettlementRequest) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"marginValue\" : 0.8008281904610115, \"valuationDate\" : \"valuationDate\", \"currency\" : \"currency\", \"generatedRegularSettlement\" : \"generatedRegularSettlement\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }
}

