/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.Optional;
import net.finmath.smartcontract.api.ApiUtil;
import net.finmath.smartcontract.model.Error;
import net.finmath.smartcontract.model.MarginRequest;
import net.finmath.smartcontract.model.MarginResult;
import net.finmath.smartcontract.model.ValueRequest;
import net.finmath.smartcontract.model.ValueResult;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

@Validated
@Tag(name="valuation", description="the valuation API")
public interface ValuationApi {
    default public Optional<NativeWebRequest> getRequest() {
        return Optional.empty();
    }

    @Operation(operationId="legacyMargin", summary="Request mapping for the margin", responses={@ApiResponse(responseCode="200", description="Margin was calculated", content={@Content(mediaType="application/json", schema=@Schema(implementation=MarginResult.class))}), @ApiResponse(responseCode="default", description="unexpected error", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/valuation/legacy/margin"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<MarginResult> _legacyMargin(@Parameter(name="MarginRequest", description="") @Valid @RequestBody(required=false) MarginRequest marginRequest) {
        return this.legacyMargin(marginRequest);
    }

    default public ResponseEntity<MarginResult> legacyMargin(MarginRequest marginRequest) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"valuationDate\" : \"valuationDate\", \"currency\" : \"currency\", \"value\" : 0.8008281904610115 }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="margin", summary="Request mapping for the value", responses={@ApiResponse(responseCode="200", description="Margin was calculated", content={@Content(mediaType="application/json", schema=@Schema(implementation=MarginResult.class))}), @ApiResponse(responseCode="default", description="unexpected error", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/valuation/margin"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<MarginResult> _margin(@Parameter(name="MarginRequest", description="") @Valid @RequestBody(required=false) MarginRequest marginRequest) {
        return this.margin(marginRequest);
    }

    default public ResponseEntity<MarginResult> margin(MarginRequest marginRequest) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"valuationDate\" : \"valuationDate\", \"currency\" : \"currency\", \"value\" : 0.8008281904610115 }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="testProductValue", summary="Request mapping for the value of a product (using fixed market data)", responses={@ApiResponse(responseCode="200", description="Value was calculated", content={@Content(mediaType="application/json", schema=@Schema(implementation=ValueResult.class))}), @ApiResponse(responseCode="default", description="unexpected error", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/valuation/legacy/test/product"}, produces={"application/json"}, consumes={"multipart/form-data"})
    default public ResponseEntity<ValueResult> _testProductValue(@Parameter(name="tradeData", description="", required=true) @RequestPart(value="tradeData", required=true) MultipartFile tradeData) {
        return this.testProductValue(tradeData);
    }

    default public ResponseEntity<ValueResult> testProductValue(MultipartFile tradeData) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"valuationDate\" : \"valuationDate\", \"currency\" : \"currency\", \"value\" : 0.8008281904610115 }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="value", summary="Request mapping for the value", responses={@ApiResponse(responseCode="200", description="Value was calculated", content={@Content(mediaType="application/json", schema=@Schema(implementation=ValueResult.class))}), @ApiResponse(responseCode="default", description="unexpected error", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/valuation/value"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<ValueResult> _value(@Parameter(name="ValueRequest", description="") @Valid @RequestBody(required=false) ValueRequest valueRequest) {
        return this.value(valueRequest);
    }

    default public ResponseEntity<ValueResult> value(ValueRequest valueRequest) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"valuationDate\" : \"valuationDate\", \"currency\" : \"currency\", \"value\" : 0.8008281904610115 }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="valueAtTime", summary="Request mapping for the value at specific evaluationTime", responses={@ApiResponse(responseCode="200", description="Value was calculated", content={@Content(mediaType="application/json", schema=@Schema(implementation=ValueResult.class))}), @ApiResponse(responseCode="default", description="unexpected error", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/valuation/valueAtTime"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<ValueResult> _valueAtTime(@Parameter(name="ValueRequest", description="") @Valid @RequestBody(required=false) ValueRequest valueRequest) {
        return this.valueAtTime(valueRequest);
    }

    default public ResponseEntity<ValueResult> valueAtTime(ValueRequest valueRequest) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"valuationDate\" : \"valuationDate\", \"currency\" : \"currency\", \"value\" : 0.8008281904610115 }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }
}

