/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.Objects;
import net.finmath.smartcontract.model.ValueResult;
import org.springframework.format.annotation.DateTimeFormat;

public class CashflowPeriod {
    @JsonProperty(value="periodStart")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime periodStart;
    @JsonProperty(value="periodEnd")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime periodEnd;
    @JsonProperty(value="fixingDate")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime fixingDate;
    @JsonProperty(value="paymentDate")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime paymentDate;
    @JsonProperty(value="cashflow")
    private ValueResult cashflow;
    @JsonProperty(value="rate")
    private Double rate;

    public CashflowPeriod periodStart(OffsetDateTime periodStart) {
        this.periodStart = periodStart;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="periodStart", requiredMode=Schema.RequiredMode.REQUIRED)
    public OffsetDateTime getPeriodStart() {
        return this.periodStart;
    }

    public void setPeriodStart(OffsetDateTime periodStart) {
        this.periodStart = periodStart;
    }

    public CashflowPeriod periodEnd(OffsetDateTime periodEnd) {
        this.periodEnd = periodEnd;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="periodEnd", requiredMode=Schema.RequiredMode.REQUIRED)
    public OffsetDateTime getPeriodEnd() {
        return this.periodEnd;
    }

    public void setPeriodEnd(OffsetDateTime periodEnd) {
        this.periodEnd = periodEnd;
    }

    public CashflowPeriod fixingDate(OffsetDateTime fixingDate) {
        this.fixingDate = fixingDate;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="fixingDate", requiredMode=Schema.RequiredMode.REQUIRED)
    public OffsetDateTime getFixingDate() {
        return this.fixingDate;
    }

    public void setFixingDate(OffsetDateTime fixingDate) {
        this.fixingDate = fixingDate;
    }

    public CashflowPeriod paymentDate(OffsetDateTime paymentDate) {
        this.paymentDate = paymentDate;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="paymentDate", requiredMode=Schema.RequiredMode.REQUIRED)
    public OffsetDateTime getPaymentDate() {
        return this.paymentDate;
    }

    public void setPaymentDate(OffsetDateTime paymentDate) {
        this.paymentDate = paymentDate;
    }

    public CashflowPeriod cashflow(ValueResult cashflow) {
        this.cashflow = cashflow;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="cashflow", requiredMode=Schema.RequiredMode.REQUIRED)
    public ValueResult getCashflow() {
        return this.cashflow;
    }

    public void setCashflow(ValueResult cashflow) {
        this.cashflow = cashflow;
    }

    public CashflowPeriod rate(Double rate) {
        this.rate = rate;
        return this;
    }

    @NotNull
    @Schema(name="rate", requiredMode=Schema.RequiredMode.REQUIRED)
    public Double getRate() {
        return this.rate;
    }

    public void setRate(Double rate) {
        this.rate = rate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CashflowPeriod cashflowPeriod = (CashflowPeriod)o;
        return Objects.equals(this.periodStart, cashflowPeriod.periodStart) && Objects.equals(this.periodEnd, cashflowPeriod.periodEnd) && Objects.equals(this.fixingDate, cashflowPeriod.fixingDate) && Objects.equals(this.paymentDate, cashflowPeriod.paymentDate) && Objects.equals(this.cashflow, cashflowPeriod.cashflow) && Objects.equals(this.rate, cashflowPeriod.rate);
    }

    public int hashCode() {
        return Objects.hash(this.periodStart, this.periodEnd, this.fixingDate, this.paymentDate, this.cashflow, this.rate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CashflowPeriod {\n");
        sb.append("    periodStart: ").append(this.toIndentedString(this.periodStart)).append("\n");
        sb.append("    periodEnd: ").append(this.toIndentedString(this.periodEnd)).append("\n");
        sb.append("    fixingDate: ").append(this.toIndentedString(this.fixingDate)).append("\n");
        sb.append("    paymentDate: ").append(this.toIndentedString(this.paymentDate)).append("\n");
        sb.append("    cashflow: ").append(this.toIndentedString(this.cashflow)).append("\n");
        sb.append("    rate: ").append(this.toIndentedString(this.rate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

