/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Objects;

public class Counterparty {
    @JsonProperty(value="bicCode")
    private String bicCode;
    @JsonProperty(value="fullName")
    private String fullName;
    @JsonProperty(value="baseUrl")
    private String baseUrl;

    public Counterparty bicCode(String bicCode) {
        this.bicCode = bicCode;
        return this;
    }

    @NotNull
    @Pattern(regexp="^[A-Z0-9]{4}[A-Z]{2}[A-Z0-9]{2,5}$")
    @Schema(name="bicCode", requiredMode=Schema.RequiredMode.REQUIRED)
    public @NotNull @Pattern(regexp="^[A-Z0-9]{4}[A-Z]{2}[A-Z0-9]{2,5}$") String getBicCode() {
        return this.bicCode;
    }

    public void setBicCode(String bicCode) {
        this.bicCode = bicCode;
    }

    public Counterparty fullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    @NotNull
    @Schema(name="fullName", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public Counterparty baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    @NotNull
    @Schema(name="baseUrl", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Counterparty counterparty = (Counterparty)o;
        return Objects.equals(this.bicCode, counterparty.bicCode) && Objects.equals(this.fullName, counterparty.fullName) && Objects.equals(this.baseUrl, counterparty.baseUrl);
    }

    public int hashCode() {
        return Objects.hash(this.bicCode, this.fullName, this.baseUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Counterparty {\n");
        sb.append("    bicCode: ").append(this.toIndentedString(this.bicCode)).append("\n");
        sb.append("    fullName: ").append(this.toIndentedString(this.fullName)).append("\n");
        sb.append("    baseUrl: ").append(this.toIndentedString(this.baseUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

