/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.finmath.smartcontract.model.MarketDataSetValuesInner;
import org.springframework.format.annotation.DateTimeFormat;

public class MarketDataSet {
    @JsonProperty(value="requestTimestamp")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime requestTimestamp;
    @JsonProperty(value="values")
    @Valid
    private List<MarketDataSetValuesInner> values = new ArrayList<MarketDataSetValuesInner>();

    public MarketDataSet requestTimestamp(OffsetDateTime requestTimestamp) {
        this.requestTimestamp = requestTimestamp;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="requestTimestamp", requiredMode=Schema.RequiredMode.REQUIRED)
    public OffsetDateTime getRequestTimestamp() {
        return this.requestTimestamp;
    }

    public void setRequestTimestamp(OffsetDateTime requestTimestamp) {
        this.requestTimestamp = requestTimestamp;
    }

    public MarketDataSet values(List<MarketDataSetValuesInner> values) {
        this.values = values;
        return this;
    }

    public MarketDataSet addValuesItem(MarketDataSetValuesInner valuesItem) {
        this.values.add(valuesItem);
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="values", requiredMode=Schema.RequiredMode.REQUIRED)
    public List<MarketDataSetValuesInner> getValues() {
        return this.values;
    }

    public void setValues(List<MarketDataSetValuesInner> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarketDataSet marketDataSet = (MarketDataSet)o;
        return Objects.equals(this.requestTimestamp, marketDataSet.requestTimestamp) && Objects.equals(this.values, marketDataSet.values);
    }

    public int hashCode() {
        return Objects.hash(this.requestTimestamp, this.values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MarketDataSet {\n");
        sb.append("    requestTimestamp: ").append(this.toIndentedString(this.requestTimestamp)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

