/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.product;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Optional;
import net.finmath.marketdata.products.AnalyticProduct;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapLeg;
import net.finmath.time.Schedule;
import net.finmath.time.ScheduleGenerator;
import net.finmath.time.businessdaycalendar.BusinessdayCalendar;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarExcludingTARGETHolidays;

public class IRSwapGenerator {
    private IRSwapGenerator() {
    }

    public static Swap generateAnalyticSwapObject(LocalDate startDate, String maturityLabel, double notional, double fixRate, boolean isReceiveFix, String forwardCurveName, String discountCurveName) {
        String frequencyLabel = forwardCurveName.contains("3M") ? "quarterly" : (forwardCurveName.contains("6M") ? "semiannual" : (forwardCurveName.contains("1M") ? "monthly" : "annual"));
        Schedule scheduleFloat = ScheduleGenerator.createScheduleFromConventions((LocalDate)startDate, (int)2, (String)"0D", (String)maturityLabel, (String)frequencyLabel, (String)"act/360", (String)"first", (String)"following", (BusinessdayCalendar)new BusinessdayCalendarExcludingTARGETHolidays(), (int)0, (int)0);
        Schedule scheduleFix = ScheduleGenerator.createScheduleFromConventions((LocalDate)startDate, (int)2, (String)"0D", (String)maturityLabel, (String)"annual", (String)"E30/360", (String)"first", (String)"following", (BusinessdayCalendar)new BusinessdayCalendarExcludingTARGETHolidays(), (int)0, (int)0);
        LocalDateTime cashFlowEffectiveDate = LocalDateTime.of(startDate, LocalTime.of(0, 0));
        boolean isNotionalExchanged = false;
        double[] notionalsFloat = new double[scheduleFloat.getNumberOfPeriods()];
        double[] spreadsFloat = new double[scheduleFloat.getNumberOfPeriods()];
        Arrays.fill(notionalsFloat, notional);
        Arrays.fill(spreadsFloat, 0.0);
        SwapLeg floatLeg = new SwapLeg(Optional.of(cashFlowEffectiveDate), scheduleFloat, forwardCurveName, notionalsFloat, spreadsFloat, discountCurveName, isNotionalExchanged);
        double[] notionalsFix = new double[scheduleFix.getNumberOfPeriods()];
        double[] spreadsFix = new double[scheduleFix.getNumberOfPeriods()];
        Arrays.fill(notionalsFix, notional);
        Arrays.fill(spreadsFix, fixRate);
        SwapLeg fixLeg = new SwapLeg(Optional.of(LocalDateTime.of(startDate, LocalTime.of(0, 0))), scheduleFix, "", fixRate, discountCurveName);
        return isReceiveFix ? new Swap((AnalyticProduct)fixLeg, (AnalyticProduct)floatLeg) : new Swap((AnalyticProduct)floatLeg, (AnalyticProduct)fixLeg);
    }
}

