/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.product;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationDataItem;
import org.apache.commons.lang3.Validate;
import org.w3c.dom.Node;

public class SmartDerivativeContractDescriptor {
    private final String dltTradeId;
    private final String dltAddress;
    private final String uniqueTradeIdentifier;
    private final LocalDateTime tradeDate;
    private final List<Party> counterparties;
    private final Map<String, Double> marginAccountInitialByPartyID;
    private final Map<String, Double> penaltyFeeInitialByPartyID;
    private final String recervicePartyID;
    private final Node underlying;
    private final List<CalibrationDataItem.Spec> marketdataItemList;
    private final String currency;
    private final String marketDataProvider;
    private final String tradeType;
    private final String initialSettlementDate;

    public SmartDerivativeContractDescriptor(String dltTradeId, String dltAddress, String uniqueTradeIdentifier, LocalDateTime tradeDate, List<Party> counterparties, Map<String, Double> marginAccountInitialByPartyID, Map<String, Double> penaltyFeeInitialByPartyID, String recervicePartyID, Node underlying, List<CalibrationDataItem.Spec> marketdataItems, String currency, String marketDataProvider, String tradeType, String initialSettlementDate) {
        this.dltTradeId = dltTradeId;
        this.dltAddress = dltAddress;
        this.uniqueTradeIdentifier = uniqueTradeIdentifier;
        this.tradeDate = tradeDate;
        this.counterparties = counterparties;
        this.marginAccountInitialByPartyID = marginAccountInitialByPartyID;
        this.penaltyFeeInitialByPartyID = penaltyFeeInitialByPartyID;
        this.recervicePartyID = recervicePartyID;
        this.marketdataItemList = marketdataItems;
        this.underlying = underlying;
        this.currency = currency;
        this.marketDataProvider = marketDataProvider;
        this.tradeType = tradeType;
        this.initialSettlementDate = initialSettlementDate;
        Validate.isTrue((counterparties.size() == 2 ? 1 : 0) != 0, (String)"Number of counterparties must be 2.", (Object[])new Object[0]);
        Validate.isTrue((marginAccountInitialByPartyID.size() == 2 ? 1 : 0) != 0, (String)"Number of margin accounts values must be 2.", (Object[])new Object[0]);
        Validate.isTrue((penaltyFeeInitialByPartyID.size() == 2 ? 1 : 0) != 0, (String)"Number of penalty fee values must be 2.", (Object[])new Object[0]);
        Validate.notNull((Object)underlying, (String)"Underlying must not be null.", (Object[])new Object[0]);
    }

    public String getDltTradeId() {
        return this.dltTradeId;
    }

    public String getDltAddress() {
        return this.dltAddress;
    }

    public String getUniqueTradeIdentifier() {
        return this.uniqueTradeIdentifier;
    }

    public LocalDateTime getTradeDate() {
        return this.tradeDate;
    }

    public List<Party> getCounterparties() {
        return this.counterparties;
    }

    public Double getMarginAccount(String partyID) {
        return this.marginAccountInitialByPartyID.get(partyID);
    }

    public Double getPenaltyFee(String partyID) {
        return this.penaltyFeeInitialByPartyID.get(partyID);
    }

    public Node getUnderlying() {
        return this.underlying;
    }

    public String getUnderlyingReceiverPartyID() {
        return this.recervicePartyID;
    }

    public List<CalibrationDataItem.Spec> getMarketdataItemList() {
        return this.marketdataItemList;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getMarketDataProvider() {
        return this.marketDataProvider;
    }

    public String getTradeType() {
        return this.tradeType;
    }

    public String getInitialSettlementDate() {
        return this.initialSettlementDate;
    }

    public static class Party {
        private final String id;
        private final String name;
        private final String href;
        private final String address;

        public Party(String id, String name, String href, String address) {
            this.id = id;
            this.name = name;
            this.href = href;
            this.address = address;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getHref() {
            return this.href;
        }

        public String getAddress() {
            return this.address;
        }

        public String toString() {
            return "Party {id='" + this.id + "', name='" + this.name + "', href='" + this.href + "', address='" + this.address + "'}";
        }
    }
}

