/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.product.xml;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.finmath.smartcontract.model.ExceptionId;
import net.finmath.smartcontract.model.SDCException;
import net.finmath.smartcontract.product.SmartDerivativeContractDescriptor;
import net.finmath.smartcontract.product.xml.Smartderivativecontract;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationDataItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SDCXMLParser {
    private static final Logger logger = LoggerFactory.getLogger(SDCXMLParser.class);

    private SDCXMLParser() {
    }

    public static SmartDerivativeContractDescriptor parse(String sdcxml) throws ParserConfigurationException, IOException, SAXException {
        Smartderivativecontract sdc = SDCXMLParser.unmarshalXml(sdcxml, Smartderivativecontract.class);
        LocalDateTime settlementDateInitial = LocalDateTime.parse(sdc.getSettlement().settlementDateInitial.trim());
        String uniqueTradeIdentifier = sdc.getUniqueTradeIdentifier().trim();
        String dltAddress = sdc.getDltAddress() == null ? "" : sdc.getDltAddress().trim();
        String dltTradeId = sdc.getDltTradeId() == null ? "" : sdc.getDltTradeId().trim();
        ArrayList<CalibrationDataItem.Spec> marketdataItems = new ArrayList<CalibrationDataItem.Spec>();
        for (Smartderivativecontract.Settlement.Marketdata.Marketdataitems.Item item : sdc.getSettlement().getMarketdata().getMarketdataitems().getItem()) {
            String symbol = item.getSymbol().get(0).trim();
            String curve = item.getCurve().get(0).trim();
            String type = item.getType().get(0).trim();
            String tenor = item.getTenor().get(0).trim();
            CalibrationDataItem.Spec spec = new CalibrationDataItem.Spec(symbol, curve, type, tenor);
            marketdataItems.add(spec);
        }
        ArrayList<SmartDerivativeContractDescriptor.Party> parties = new ArrayList<SmartDerivativeContractDescriptor.Party>();
        HashMap<String, Double> marginAccountInitialByPartyID = new HashMap<String, Double>();
        HashMap<String, Double> penaltyFeeInitialByPartyID = new HashMap<String, Double>();
        for (Smartderivativecontract.Parties.Party p : sdc.getParties().getParty()) {
            SmartDerivativeContractDescriptor.Party party = new SmartDerivativeContractDescriptor.Party(p.getId().trim(), p.getName().trim(), null, p.getAddress().trim());
            parties.add(party);
            marginAccountInitialByPartyID.put(party.getId(), p.getMarginAccount().getValue());
            penaltyFeeInitialByPartyID.put(party.getId(), p.getPenaltyFee().getValue());
        }
        String receiverPartyID = sdc.getReceiverPartyID().trim();
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(sdcxml.getBytes(StandardCharsets.UTF_8)));
        document.getDocumentElement().normalize();
        Node underlying = document.getElementsByTagName("underlying").item(0).getFirstChild();
        if (!underlying.getNodeName().contains("dataDocument")) {
            underlying = underlying.getNextSibling();
        }
        String currency = sdc.getSettlementCurrency();
        String marketDataProvider = sdc.getSettlement().getMarketdata().getProvider().trim();
        String tradeType = sdc.getTradeType();
        String initialSettlementDate = sdc.getSettlement().getSettlementDateInitial().trim();
        return new SmartDerivativeContractDescriptor(dltTradeId, dltAddress, uniqueTradeIdentifier, settlementDateInitial, parties, marginAccountInitialByPartyID, penaltyFeeInitialByPartyID, receiverPartyID, underlying, marketdataItems, currency, marketDataProvider, tradeType, initialSettlementDate);
    }

    public static <T> T unmarshalXml(String xml, Class<T> t) {
        try {
            StringReader reader = new StringReader(xml);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{t, BigDecimal.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            return (T)unmarshaller.unmarshal((Reader)reader);
        }
        catch (JAXBException e) {
            logger.error("unmarshalXml: jaxb error, ", (Throwable)e);
            throw new SDCException(ExceptionId.SDC_JAXB_ERROR, e.getMessage(), 400);
        }
    }

    public static <T> String marshalClassToXMLString(T t) {
        try {
            JAXBContext jaxbContextSettlement = JAXBContext.newInstance((Class[])new Class[]{t.getClass()});
            Marshaller jaxbMarshaller = jaxbContextSettlement.createMarshaller();
            if (t instanceof Smartderivativecontract) {
                jaxbMarshaller.setProperty("jaxb.schemaLocation", (Object)"uri:sdc smartderivativecontract.xsd");
            }
            StringWriter writer = new StringWriter();
            jaxbMarshaller.marshal(t, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            logger.error("marshalClassToXMLString: jaxb error, ", (Throwable)e);
            throw new SDCException(ExceptionId.SDC_JAXB_ERROR, e.getMessage(), 400);
        }
    }

    public static String marshalSDCToXMLString(Smartderivativecontract smartderivativecontract) {
        return SDCXMLParser.marshalClassToXMLString(smartderivativecontract).replaceAll("<fpml:dataDocument fpmlVersion=\"5-9\">", "<dataDocument fpmlVersion=\"5-9\" xmlns=\"http://www.fpml.org/FpML-5/confirmation\">").replaceAll("fpml:", "");
    }
}

