/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.settlement;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.finmath.smartcontract.model.ExceptionId;
import net.finmath.smartcontract.model.MarketDataList;
import net.finmath.smartcontract.model.SDCException;
import net.finmath.smartcontract.product.SmartDerivativeContractDescriptor;
import net.finmath.smartcontract.product.xml.SDCXMLParser;
import net.finmath.smartcontract.settlement.Settlement;
import net.finmath.smartcontract.settlement.SettlementInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettlementGenerator {
    private static final Logger logger = LoggerFactory.getLogger(SettlementGenerator.class);
    private Settlement settlement;

    public SettlementGenerator generateInitialSettlementXml(String marketDataXml, SmartDerivativeContractDescriptor sdc) {
        this.generateSettlement(marketDataXml, Settlement.SettlementType.INITIAL, sdc, BigDecimal.ZERO);
        return this.settlementNPVPrevious(BigDecimal.ZERO);
    }

    public SettlementGenerator generateRegularSettlementXml(String marketDataXml, SmartDerivativeContractDescriptor sdc, BigDecimal marginValue) {
        return this.generateSettlement(marketDataXml, Settlement.SettlementType.REGULAR, sdc, marginValue);
    }

    private SettlementGenerator generateSettlement(String marketDataXml, Settlement.SettlementType settlementType, SmartDerivativeContractDescriptor sdc, BigDecimal marginValue) {
        MarketDataList marketDataList = SDCXMLParser.unmarshalXml(marketDataXml, MarketDataList.class);
        this.settlement = new Settlement();
        this.settlement.setTradeId(sdc.getDltTradeId());
        this.settlement.setSettlementType(settlementType);
        this.settlement.setCurrency(sdc.getCurrency());
        this.settlement.setMarginValue(marginValue);
        this.settlement.setSettlementTime(ZonedDateTime.now());
        this.settlement.setMarketData(marketDataList);
        return this;
    }

    public SettlementGenerator marginLimits(List<BigDecimal> marginLimits) {
        this.settlement.setMarginLimits(marginLimits);
        return this;
    }

    public SettlementGenerator settlementNPV(BigDecimal settlementNPV) {
        this.settlement.setSettlementNPV(settlementNPV);
        return this;
    }

    public SettlementGenerator settlementNPVPrevious(BigDecimal settlementNPVPrevious) {
        this.settlement.setSettlementNPVPrevious(settlementNPVPrevious);
        return this;
    }

    public SettlementGenerator settlementTimeNext(ZonedDateTime settlementTimeNext) {
        this.settlement.setSettlementTimeNext(settlementTimeNext);
        return this;
    }

    public SettlementGenerator settlementNPVNext(BigDecimal settlementNPVNext) {
        this.settlement.setSettlementNPVNext(settlementNPVNext);
        return this;
    }

    public SettlementGenerator settlementInfo(Map<String, BigDecimal> info) {
        this.settlement.setSettlementInfos(info.entrySet().stream().map(e -> new SettlementInfo((String)e.getKey(), (BigDecimal)e.getValue())).toList());
        return this;
    }

    public Settlement buildObject() {
        String settlementString = SDCXMLParser.marshalClassToXMLString(this.settlement);
        if (SettlementGenerator.allFieldsSet(this.settlement)) {
            return this.settlement;
        }
        logger.error("buildObject: missing input for settlement, settlement string so far: {}", (Object)settlementString);
        throw new SDCException(ExceptionId.SDC_WRONG_INPUT, "settlement input incomplete", 400);
    }

    public String build() {
        String settlementString = SDCXMLParser.marshalClassToXMLString(this.settlement);
        if (SettlementGenerator.allFieldsSet(this.settlement)) {
            return settlementString;
        }
        logger.error("buildString: missing input for settlement, settlement string so far: {}", (Object)settlementString);
        throw new SDCException(ExceptionId.SDC_WRONG_INPUT, "settlement input incomplete", 400);
    }

    private static boolean allFieldsSet(Settlement settlement) {
        return Arrays.stream(settlement.getClass().getDeclaredFields()).peek(f -> f.setAccessible(true)).map(f -> SettlementGenerator.getFieldValue(f, settlement)).allMatch(Objects::nonNull);
    }

    private static Object getFieldValue(Field field, Object target) {
        try {
            return field.get(target);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

