/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.valuation.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import net.finmath.smartcontract.model.MarginRequest;
import net.finmath.smartcontract.model.MarginResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class ValuationClient {
    private static final Logger logger = LoggerFactory.getLogger(ValuationClient.class);
    private static final String BASIC = "Basic ";

    public static void main(String[] args) throws Exception {
        String url = "http://localhost:8080";
        String authString = "user1:password1";
        if (args.length != 2) {
            logger.info("Usage: ValuationClient <url> <user>:<password>");
        }
        if (args.length == 2) {
            authString = args[1];
        } else {
            logger.info("Using default credentials {}", (Object)authString);
        }
        if (args.length >= 1) {
            url = args[0];
        } else {
            logger.info("Using default endpoint {}", (Object)url);
        }
        String marketDataStartXml = new String(Objects.requireNonNull(ValuationClient.class.getClassLoader().getResourceAsStream("net/finmath/smartcontract/valuation/client/md_testset1.xml")).readAllBytes(), StandardCharsets.UTF_8);
        String marketDataEndXml = new String(Objects.requireNonNull(ValuationClient.class.getClassLoader().getResourceAsStream("net/finmath/smartcontract/valuation/client/md_testset2.xml")).readAllBytes(), StandardCharsets.UTF_8);
        String product = new String(Objects.requireNonNull(ValuationClient.class.getClassLoader().getResourceAsStream("net.finmath.smartcontract.product.xml/smartderivativecontract.xml")).readAllBytes(), StandardCharsets.UTF_8);
        MarginRequest marginRequest = new MarginRequest().marketDataStart(marketDataStartXml).marketDataEnd(marketDataEndXml).tradeData(product).valuationDate("");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String base64Creds = Base64.getEncoder().encodeToString(authString.getBytes());
        headers.add("Authorization", BASIC + base64Creds);
        RequestEntity requestEntity = new RequestEntity((Object)marginRequest, (MultiValueMap)headers, HttpMethod.POST, new URI(url + "/valuation/margin"), MarginRequest.class);
        ResponseEntity response = new RestTemplate().exchange(requestEntity, MarginResult.class);
        MarginResult result = (MarginResult)response.getBody();
        logger.info("Received the valuation result:\n{}", (Object)result);
        ValuationClient.printInfoGit(url, authString);
        ValuationClient.printInfoFinmath(url, authString);
    }

    private static void printInfoGit(String url, String authString) throws URISyntaxException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String base64Creds = Base64.getEncoder().encodeToString(authString.getBytes());
        headers.add("Authorization", BASIC + base64Creds);
        RequestEntity requestEntity = new RequestEntity(null, (MultiValueMap)headers, HttpMethod.GET, new URI(url + "/info/git"), String.class);
        ResponseEntity response = new RestTemplate().exchange(requestEntity, String.class);
        logger.info("git status");
        logger.info((String)response.getBody());
    }

    private static void printInfoFinmath(String url, String authString) throws URISyntaxException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String base64Creds = Base64.getEncoder().encodeToString(authString.getBytes());
        headers.add("Authorization", BASIC + base64Creds);
        RequestEntity requestEntity = new RequestEntity(null, (MultiValueMap)headers, HttpMethod.GET, new URI(url + "/info/finmath"), String.class);
        ResponseEntity response = new RestTemplate().exchange(requestEntity, String.class);
        logger.info("finmath-lib version");
        logger.info((String)response.getBody());
    }
}

