/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.valuation.implementation;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.DoubleUnaryOperator;
import net.finmath.marketdata.products.AnalyticProduct;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapLeg;
import net.finmath.modelling.DescribedProduct;
import net.finmath.modelling.ProductDescriptor;
import net.finmath.modelling.descriptor.InterestRateSwapLegProductDescriptor;
import net.finmath.modelling.descriptor.InterestRateSwapProductDescriptor;
import net.finmath.modelling.descriptor.xmlparser.FPMLParser;
import net.finmath.modelling.productfactory.InterestRateAnalyticProductFactory;
import net.finmath.smartcontract.model.MarginResult;
import net.finmath.smartcontract.model.MarketDataList;
import net.finmath.smartcontract.model.ValueResult;
import net.finmath.smartcontract.product.SmartDerivativeContractDescriptor;
import net.finmath.smartcontract.product.xml.SDCXMLParser;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationDataItem;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationDataset;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationParserDataItems;
import net.finmath.smartcontract.valuation.marketdata.data.MarketDataPoint;
import net.finmath.smartcontract.valuation.oracle.SmartDerivativeContractSettlementOracle;
import net.finmath.smartcontract.valuation.oracle.interestrates.ValuationOraclePlainSwap;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarginCalculator {
    private static final Logger logger = LoggerFactory.getLogger(MarginCalculator.class);
    private final DoubleUnaryOperator rounding;
    private static final String FORWARD_EUR_6M = "forward-EUR-6M";
    private static final String DISCOUNT_EUR_OIS = "discount-EUR-OIS";

    public MarginCalculator(DoubleUnaryOperator rounding) {
        this.rounding = rounding;
    }

    public MarginCalculator() {
        this(x -> (double)Math.round(x * 1000.0) / 1000.0);
    }

    public Map<String, BigDecimal> getValues(String marketDataStart, String marketDataEnd, String productData) throws Exception {
        SmartDerivativeContractDescriptor productDescriptor = SDCXMLParser.parse(productData);
        CalibrationDataset setStart = null;
        CalibrationDataset setEnd = null;
        try {
            setStart = CalibrationParserDataItems.getCalibrationDataSetFromXML(marketDataStart, productDescriptor.getMarketdataItemList());
            setEnd = CalibrationParserDataItems.getCalibrationDataSetFromXML(marketDataEnd, productDescriptor.getMarketdataItemList());
        }
        catch (Exception e) {
            List<CalibrationDataset> marketDataSetsStart = CalibrationParserDataItems.getScenariosFromJsonString(marketDataStart);
            Validate.isTrue((marketDataSetsStart.size() == 1 ? 1 : 0) != 0, (String)"Parameter marketDataStart should be only a single market data set", (Object[])new Object[0]);
            List<CalibrationDataset> marketDataSetsEnd = CalibrationParserDataItems.getScenariosFromJsonString(marketDataEnd);
            Validate.isTrue((marketDataSetsEnd.size() == 1 ? 1 : 0) != 0, (String)"Parameter marketDataStart should be only a single market data set", (Object[])new Object[0]);
        }
        String ownerPartyID = productDescriptor.getUnderlyingReceiverPartyID();
        InterestRateSwapProductDescriptor underlying = (InterestRateSwapProductDescriptor)new FPMLParser(ownerPartyID, FORWARD_EUR_6M, DISCOUNT_EUR_OIS).getProductDescriptor(productDescriptor.getUnderlying());
        LocalDateTime startDate = setStart.getDate();
        LocalDateTime endDate = setEnd.getDate();
        Map<String, BigDecimal> values = this.calculateMargin(List.of(setStart, setEnd), startDate, endDate, productDescriptor, underlying);
        return values;
    }

    public MarginResult getValue(String marketDataStart, String marketDataEnd, String productData) throws Exception {
        BigDecimal value = this.getValues(marketDataStart, marketDataEnd, productData).get("value");
        String currency = "EUR";
        LocalDateTime valuationDate = LocalDateTime.now();
        return new MarginResult().value(value).currency(currency).valuationDate(valuationDate.toString());
    }

    public Map<String, BigDecimal> getValues(MarketDataList marketDataStart, MarketDataList marketDataEnd, String productData) throws Exception {
        SmartDerivativeContractDescriptor productDescriptor = SDCXMLParser.parse(productData);
        List<CalibrationDataItem.Spec> marketdataItemList = productDescriptor.getMarketdataItemList();
        HashSet<CalibrationDataItem> calibrationDataItemsStart = new HashSet<CalibrationDataItem>();
        List<MarketDataPoint> marketDataValuesStart = marketDataStart.getPoints();
        marketdataItemList.forEach(marketDataItemSpec -> marketDataValuesStart.stream().filter(marketDataValue -> marketDataValue.getId().equals(marketDataItemSpec.getKey())).map(mdv -> new CalibrationDataItem((CalibrationDataItem.Spec)marketDataItemSpec, mdv.getValue(), mdv.getTimeStamp())).forEach(calibrationDataItemsStart::add));
        ArrayList<CalibrationDataset> marketDataListStart = new ArrayList<CalibrationDataset>();
        marketDataListStart.add(new CalibrationDataset(calibrationDataItemsStart, marketDataStart.getRequestTimeStamp()));
        HashSet<CalibrationDataItem> calibrationDataItemsEnd = new HashSet<CalibrationDataItem>();
        List<MarketDataPoint> marketDataValuesEnd = marketDataEnd.getPoints();
        marketdataItemList.forEach(marketDataItemSpec -> marketDataValuesEnd.stream().filter(marketDataValue -> marketDataValue.getId().equals(marketDataItemSpec.getKey())).map(mdv -> new CalibrationDataItem((CalibrationDataItem.Spec)marketDataItemSpec, mdv.getValue(), mdv.getTimeStamp())).forEach(calibrationDataItemsEnd::add));
        ArrayList<CalibrationDataset> marketDataListEnd = new ArrayList<CalibrationDataset>();
        marketDataListEnd.add(new CalibrationDataset(calibrationDataItemsEnd, marketDataEnd.getRequestTimeStamp()));
        String ownerPartyID = productDescriptor.getUnderlyingReceiverPartyID();
        InterestRateSwapProductDescriptor underlying = (InterestRateSwapProductDescriptor)new FPMLParser(ownerPartyID, FORWARD_EUR_6M, DISCOUNT_EUR_OIS).getProductDescriptor(productDescriptor.getUnderlying());
        LocalDateTime startDate = ((CalibrationDataset)marketDataListStart.get(0)).getDate();
        LocalDateTime endDate = ((CalibrationDataset)marketDataListEnd.get(0)).getDate();
        Map<String, BigDecimal> values = this.calculateMargin(List.of((CalibrationDataset)marketDataListStart.get(0), (CalibrationDataset)marketDataListEnd.get(0)), startDate, endDate, productDescriptor, underlying);
        return values;
    }

    public MarginResult getValue(MarketDataList marketDataStart, MarketDataList marketDataEnd, String productData) throws Exception {
        Map<String, BigDecimal> values = this.getValues(marketDataStart, marketDataEnd, productData);
        String currency = "EUR";
        LocalDateTime valuationDate = LocalDateTime.now();
        return new MarginResult().value(values.get("values")).currency(currency).valuationDate(valuationDate.toString());
    }

    public ValueResult getValue(String marketData, String productData) throws Exception {
        SmartDerivativeContractDescriptor productDescriptor = SDCXMLParser.parse(productData);
        String ownerPartyID = productDescriptor.getUnderlyingReceiverPartyID();
        InterestRateSwapProductDescriptor underlying = (InterestRateSwapProductDescriptor)new FPMLParser(ownerPartyID, FORWARD_EUR_6M, DISCOUNT_EUR_OIS).getProductDescriptor(productDescriptor.getUnderlying());
        CalibrationDataset set = CalibrationParserDataItems.getCalibrationDataSetFromXML(marketData, productDescriptor.getMarketdataItemList());
        BigDecimal value = this.calculateMargin(List.of(set), null, set.getDate(), productDescriptor, underlying).get("value");
        String currency = "EUR";
        LocalDateTime valuationDate = LocalDateTime.now();
        return new ValueResult().value(value).currency(currency).valuationDate(valuationDate.toString());
    }

    public ValueResult getValueAtEvaluationTime(String marketData, String productData, LocalDateTime evaluationTime) throws Exception {
        SmartDerivativeContractDescriptor productDescriptor = SDCXMLParser.parse(productData);
        String ownerPartyID = productDescriptor.getUnderlyingReceiverPartyID();
        InterestRateSwapProductDescriptor underlying = (InterestRateSwapProductDescriptor)new FPMLParser(ownerPartyID, FORWARD_EUR_6M, DISCOUNT_EUR_OIS).getProductDescriptor(productDescriptor.getUnderlying());
        CalibrationDataset set = CalibrationParserDataItems.getCalibrationDataSetFromXML(marketData, productDescriptor.getMarketdataItemList());
        BigDecimal valueAtTime = this.calculateValueAtTime(List.of(set), evaluationTime, set.getDate(), productDescriptor, underlying);
        String currency = "EUR";
        logger.info("calculated value at time: {}", (Object)valueAtTime);
        return new ValueResult().value(valueAtTime).currency(currency).valuationDate(evaluationTime.toString());
    }

    public ValueResult getValue(MarketDataList marketData, String productData) throws Exception {
        SmartDerivativeContractDescriptor productDescriptor = SDCXMLParser.parse(productData);
        HashSet<CalibrationDataItem> calibrationDataItems = new HashSet<CalibrationDataItem>();
        List<CalibrationDataItem.Spec> marketdataItemList = productDescriptor.getMarketdataItemList();
        List<MarketDataPoint> marketDataValues = marketData.getPoints();
        marketdataItemList.forEach(marketDataItemSpec -> marketDataValues.stream().filter(marketDataValue -> marketDataValue.getId().equals(marketDataItemSpec.getKey())).map(mdv -> new CalibrationDataItem((CalibrationDataItem.Spec)marketDataItemSpec, mdv.getValue(), mdv.getTimeStamp())).forEach(calibrationDataItems::add));
        ArrayList<CalibrationDataset> marketDataList = new ArrayList<CalibrationDataset>();
        marketDataList.add(new CalibrationDataset(calibrationDataItems, marketData.getRequestTimeStamp()));
        String ownerPartyID = productDescriptor.getUnderlyingReceiverPartyID();
        InterestRateSwapProductDescriptor underlying = (InterestRateSwapProductDescriptor)new FPMLParser(ownerPartyID, FORWARD_EUR_6M, DISCOUNT_EUR_OIS).getProductDescriptor(productDescriptor.getUnderlying());
        LocalDateTime endDate = ((CalibrationDataset)marketDataList.get(0)).getDate();
        BigDecimal value = this.calculateMargin(marketDataList, null, endDate, productDescriptor, underlying).get("value");
        String currency = "EUR";
        return new ValueResult().value(value).currency(currency).valuationDate(marketData.getRequestTimeStamp().toString());
    }

    private Map<String, BigDecimal> calculateMargin(List<CalibrationDataset> marketDataList, LocalDateTime startDate, LocalDateTime endState, SmartDerivativeContractDescriptor productDescriptor, InterestRateSwapProductDescriptor underlying) {
        LocalDate referenceDate = productDescriptor.getTradeDate().toLocalDate();
        InterestRateSwapLegProductDescriptor legReceiver = (InterestRateSwapLegProductDescriptor)underlying.getLegReceiver();
        InterestRateSwapLegProductDescriptor legPayer = (InterestRateSwapLegProductDescriptor)underlying.getLegPayer();
        InterestRateAnalyticProductFactory productFactory = new InterestRateAnalyticProductFactory(referenceDate);
        DescribedProduct legReceiverProduct = productFactory.getProductFromDescriptor((ProductDescriptor)legReceiver);
        DescribedProduct legPayerProduct = productFactory.getProductFromDescriptor((ProductDescriptor)legPayer);
        Swap swap = new Swap((AnalyticProduct)((SwapLeg)legReceiverProduct), (AnalyticProduct)((SwapLeg)legPayerProduct));
        Map<String, SwapLeg> products = Map.of("value", swap, "value.receiverLeg", (SwapLeg)legReceiverProduct);
        ValuationOraclePlainSwap oracle = new ValuationOraclePlainSwap(products, marketDataList);
        SmartDerivativeContractSettlementOracle margin = new SmartDerivativeContractSettlementOracle(oracle);
        Map<String, BigDecimal> marginCall = Objects.isNull(startDate) ? oracle.getValues(endState, endState) : margin.getMargin(startDate, endState);
        marginCall.put("value.payerLeg", marginCall.get("value.receiverLeg").subtract(marginCall.get("value")));
        logger.info("margin call: {}", marginCall);
        return marginCall;
    }

    private BigDecimal calculateValueAtTime(List<CalibrationDataset> marketDataList, LocalDateTime evaluationTime, LocalDateTime marketDataTime, SmartDerivativeContractDescriptor productDescriptor, InterestRateSwapProductDescriptor underlying) {
        LocalDate referenceDate = productDescriptor.getTradeDate().toLocalDate();
        InterestRateSwapLegProductDescriptor legReceiver = (InterestRateSwapLegProductDescriptor)underlying.getLegReceiver();
        InterestRateSwapLegProductDescriptor legPayer = (InterestRateSwapLegProductDescriptor)underlying.getLegPayer();
        InterestRateAnalyticProductFactory productFactory = new InterestRateAnalyticProductFactory(referenceDate);
        DescribedProduct legReceiverProduct = productFactory.getProductFromDescriptor((ProductDescriptor)legReceiver);
        DescribedProduct legPayerProduct = productFactory.getProductFromDescriptor((ProductDescriptor)legPayer);
        Swap swap = new Swap((AnalyticProduct)((SwapLeg)legReceiverProduct), (AnalyticProduct)((SwapLeg)legPayerProduct));
        Map<String, SwapLeg> products = Map.of("value", swap, "value.receiverLeg", (SwapLeg)legReceiverProduct, "value.payerLeg", (SwapLeg)legPayerProduct);
        ValuationOraclePlainSwap oracle = new ValuationOraclePlainSwap(products, marketDataList);
        BigDecimal value = oracle.getValue(evaluationTime, marketDataTime);
        return value;
    }
}

