/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.valuation.implementation.reactive;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.function.Function;
import net.finmath.smartcontract.model.ValueResult;
import net.finmath.smartcontract.valuation.implementation.MarginCalculator;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationDataset;

public class ConditionalSettlementCalculator
implements Function<CalibrationDataset, ValueResult>,
Serializable {
    private final BigDecimal resultTriggerValue;
    private final String sdcXML;
    private String previousmarketdata = null;
    private final MarginCalculator calculator = new MarginCalculator();

    public ConditionalSettlementCalculator(String sdcXML, BigDecimal resultTriggerValue) {
        this.sdcXML = sdcXML;
        this.resultTriggerValue = resultTriggerValue;
    }

    @Override
    public ValueResult apply(CalibrationDataset actualmarketdata) {
        ValueResult defaultResult = new ValueResult();
        defaultResult.setValue(null);
        ValueResult finalResult = defaultResult;
        String marketDataAsJson = actualmarketdata.serializeToJson();
        try {
            if (this.previousmarketdata != null) {
                ValueResult marginResult = this.calculator.getValue(marketDataAsJson, this.sdcXML);
                this.previousmarketdata = marketDataAsJson;
                finalResult = marginResult;
            } else {
                this.previousmarketdata = marketDataAsJson;
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return finalResult;
    }
}

