/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.valuation.marketdata;

import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketListener;
import io.reactivex.rxjava3.functions.Consumer;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import net.finmath.smartcontract.model.MarketDataList;
import net.finmath.smartcontract.product.SmartDerivativeContractDescriptor;
import net.finmath.smartcontract.product.xml.SDCXMLParser;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationDataItem;
import net.finmath.smartcontract.valuation.marketdata.generators.MarketDataGeneratorWebsocket;
import net.finmath.smartcontract.valuation.marketdata.generators.WebSocketConnector;

public class LaunchAGenerator {
    public static void main(String[] args) throws Exception {
        String sdcXML = new String(LaunchAGenerator.class.getClassLoader().getResourceAsStream("net.finmath.smartcontract.product.xml/smartderivativecontract.xml").readAllBytes(), StandardCharsets.UTF_8);
        SmartDerivativeContractDescriptor sdc = SDCXMLParser.parse(sdcXML);
        List<CalibrationDataItem.Spec> mdItemList = sdc.getMarketdataItemList();
        String connectionPropertiesFile = "<propertiesfile>";
        Properties properties = new Properties();
        properties.load(new FileInputStream(connectionPropertiesFile));
        WebSocketConnector connector = new WebSocketConnector(properties);
        final WebSocket socket = connector.getWebSocket();
        final MarketDataGeneratorWebsocket emitter = new MarketDataGeneratorWebsocket(connector.getAuthJson(), connector.getPosition(), mdItemList);
        socket.addListener((WebSocketListener)emitter);
        socket.connect();
        Consumer<MarketDataList> marketDataWriter = new Consumer<MarketDataList>(){

            public void accept(MarketDataList s) throws Throwable {
                System.out.println("Consumer MarketDataStorage: Stored Market Data at: ");
                System.out.println(socket.isOpen());
                File file = new File("md_testset3.xml");
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{MarketDataList.class});
                Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
                jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
                jaxbMarshaller.marshal((Object)s, file);
                emitter.closeStreamsAndLogoff(socket);
                socket.sendClose();
            }
        };
        emitter.asObservable().take(1L).subscribe((Consumer)marketDataWriter);
    }
}

