/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.valuation.marketdata.curvecalibration;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class CalibrationDataItem {
    private static final String REGEX = "((?<=[a-zA-Z])(?=[0-9]))|((?<=[0-9])(?=[a-zA-Z]))";
    final Spec spec;
    final Double quote;
    final LocalDateTime dateTime;

    public CalibrationDataItem(Spec spec, Double quote, LocalDateTime dateTime) {
        this.spec = spec;
        this.quote = quote;
        this.dateTime = dateTime;
    }

    public CalibrationDataItem getClonedScaled(double factor) {
        return new CalibrationDataItem(this.spec, this.quote / factor, this.dateTime);
    }

    public CalibrationDataItem getClonedShifted(double amount) {
        return new CalibrationDataItem(this.spec, this.quote + amount, this.dateTime);
    }

    public Spec getSpec() {
        return this.spec;
    }

    public String getCurveName() {
        return this.getSpec().getCurveName();
    }

    public String getProductName() {
        return this.getSpec().getProductName();
    }

    public String getMaturity() {
        return this.getSpec().getMaturity();
    }

    public Double getQuote() {
        return this.quote;
    }

    public Integer getDaysToMaturity() {
        List<String> list = Arrays.asList(this.getSpec().getMaturity().split(REGEX));
        int nTimeUnits = Integer.parseInt(list.get(0));
        String timeUnitKey = list.get(1);
        if (timeUnitKey.equals("D")) {
            return nTimeUnits;
        }
        if (timeUnitKey.equals("M")) {
            return nTimeUnits * 30;
        }
        if (timeUnitKey.equals("Y")) {
            return nTimeUnits * 360;
        }
        return 0;
    }

    public String getDateString() {
        return this.dateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }

    public LocalDate getDate() {
        return this.dateTime.toLocalDate();
    }

    public LocalDateTime getDateTime() {
        return this.dateTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CalibrationDataItem that = (CalibrationDataItem)o;
        return Objects.equals(this.spec, that.spec) && Objects.equals(this.quote, that.quote) && Objects.equals(this.dateTime, that.dateTime);
    }

    public int hashCode() {
        return Objects.hash(this.spec, this.quote, this.dateTime);
    }

    public static class Spec {
        private final String key;
        private final String curveName;
        private final String productName;
        private final String maturity;

        public Spec(String key, String curveName, String productName, String maturity) {
            this.key = key;
            this.curveName = curveName;
            this.productName = productName;
            this.maturity = maturity;
        }

        public String getKey() {
            return this.key;
        }

        public String getCurveName() {
            return this.curveName;
        }

        public String getProductName() {
            return this.productName;
        }

        public String getMaturity() {
            return this.maturity;
        }

        public int hashCode() {
            return Objects.hash(this.key, this.curveName, this.productName, this.maturity);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Spec spec = (Spec)o;
            return Objects.equals(this.key, spec.key) && Objects.equals(this.curveName, spec.curveName) && Objects.equals(this.productName, spec.productName) && Objects.equals(this.maturity, spec.maturity);
        }
    }
}

